/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft;

import com.google.common.base.Preconditions;
import net.kyori.adventure.key.Key;
import org.aincraft.EntityModelAttributeRegistry;
import org.aincraft.EntityModelData;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class EntityModelAttributes {
    public static final EntityModelData.EntityModelAttribute<Vector3f> TRANSLATION = EntityModelAttributes.attribute("translation");
    public static final EntityModelData.EntityModelAttribute<Vector3f> SCALE = EntityModelAttributes.attribute("scale");
    public static final EntityModelData.EntityModelAttribute<Quaternionf> LEFT_ROTATION = EntityModelAttributes.attribute("left_rotation");
    public static final EntityModelData.EntityModelAttribute<Quaternionf> RIGHT_ROTATION = EntityModelAttributes.attribute("right_rotation");
    public static final EntityModelData.EntityModelAttribute<World> WORLD = EntityModelAttributes.attribute("world");
    public static final EntityModelData.EntityModelAttribute<Vector3f> POSITION = EntityModelAttributes.attribute("position");
    public static final EntityModelData.EntityModelAttribute<Key> ITEM_MODEL = EntityModelAttributes.attribute("item_model");
    public static final EntityModelData.EntityModelAttribute<Boolean> INVISIBLE = EntityModelAttributes.attribute("invisible");
    public static final EntityModelData.EntityModelAttribute<Boolean> GLOWING = EntityModelAttributes.attribute("glowing");
    public static final EntityModelData.EntityModelAttribute<Integer> GLOW_COLOR_OVERRIDE = EntityModelAttributes.attribute("glow_color");
    public static final EntityModelData.EntityModelAttribute<Integer> SLIME_SIZE = EntityModelAttributes.attribute("slime_size");
    public static final EntityModelData.EntityModelAttribute<Float> SHULKER_PEEK = EntityModelAttributes.attribute("shulker_peek");

    private EntityModelAttributes() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    @NotNull
    static <T> EntityModelData.EntityModelAttribute<T> attribute(String key) throws IllegalArgumentException {
        EntityModelAttributeImpl<?> attribute = EntityModelAttributeRegistry.REGISTERED_ATTRIBUTES.get(key);
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0);
        return attribute;
    }

    public record EntityModelAttributeImpl<T>(String key, Class<T> clazz) implements EntityModelData.EntityModelAttribute<T>
    {
    }
}

