/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.aincraft.ConnectionException;
import org.aincraft.ConnectionSource;
import org.aincraft.DatabaseType;

public final class HikariSourceImpl
implements ConnectionSource.SQLConnectionSource {
    private final HikariDataSource dataSource;
    private final DatabaseType type;

    public HikariSourceImpl(HikariDataSource dataSource, DatabaseType type) {
        this.dataSource = dataSource;
        this.type = type;
    }

    @Override
    public void close() throws ConnectionException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @Override
    public boolean closed() throws ConnectionException {
        return this.dataSource.isClosed();
    }

    @Override
    public DatabaseType type() {
        return this.type;
    }

    @Override
    public Connection connection() throws ConnectionException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionException("");
        }
    }
}

