/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft;

import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.aincraft.ConnectionSource;
import org.aincraft.ConnectionSourceFactory;
import org.aincraft.DatabaseType;
import org.aincraft.HikariSourceImpl;
import org.aincraft.SQLiteSourceImpl;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

final class SQLConnectionSourceFactoryImpl
implements ConnectionSourceFactory {
    private final Plugin plugin;

    public SQLConnectionSourceFactoryImpl(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public ConnectionSource create(DatabaseType type, ConfigurationSection configuration) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)type.isRelational());
        return switch (type) {
            case DatabaseType.MYSQL, DatabaseType.POSTGRES -> new HikariSourceImpl(new HikariDataSource(SQLConnectionSourceFactoryImpl.parseHikariConfig(configuration)), type);
            case DatabaseType.SQLITE -> SQLiteSourceImpl.create(this.plugin, configuration.getString("path"));
            default -> throw new IllegalArgumentException("failed to create a source for this database type");
        };
    }

    private static HikariConfig parseHikariConfig(ConfigurationSection configuration) {
        long maxLifetime;
        long idleTimeout;
        long connectionTimeout;
        int minIdle;
        HikariConfig hikariConfig = new HikariConfig();
        String jdbcUrl = configuration.getString("jdbc-url");
        String username = configuration.getString("username");
        String password = configuration.getString("password");
        Preconditions.checkNotNull((Object)jdbcUrl, (Object)"missing required field: database.jdbc-url");
        Preconditions.checkNotNull((Object)username, (Object)"missing required field: database.username");
        Preconditions.checkNotNull((Object)password, (Object)"missing required field: database.password");
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        int maxPoolSize = configuration.getInt("maximum-pool-size", -1);
        if (maxPoolSize > 0) {
            hikariConfig.setMaximumPoolSize(maxPoolSize);
        }
        if ((minIdle = configuration.getInt("minimum-idle", -1)) >= 0) {
            hikariConfig.setMinimumIdle(minIdle);
        }
        if ((connectionTimeout = configuration.getLong("connection-timeout", -1L)) > 0L) {
            hikariConfig.setConnectionTimeout(connectionTimeout);
        }
        if ((idleTimeout = configuration.getLong("idle-timeout", -1L)) > 0L) {
            hikariConfig.setIdleTimeout(idleTimeout);
        }
        if ((maxLifetime = configuration.getLong("max-lifetime", -1L)) > 0L) {
            hikariConfig.setMaxLifetime(maxLifetime);
        }
        return hikariConfig;
    }
}

