/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aincraft.ConnectionException;
import org.aincraft.ConnectionSource;
import org.aincraft.DatabaseType;

final class MongoConnectionSourceImpl
implements ConnectionSource.MongoConnectionSource {
    private final MongoClient client;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    MongoConnectionSourceImpl(MongoClient client) {
        this.client = client;
    }

    @Override
    public void close() throws ConnectionException {
        try {
            this.client.close();
            this.closed.set(true);
        }
        catch (Exception e) {
            throw new ConnectionException("failed to close mongo client");
        }
    }

    @Override
    public boolean closed() throws ConnectionException {
        return this.closed.get();
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.MONGO;
    }

    @Override
    public MongoClient getClient() {
        return this.client;
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return this.client.getDatabase(databaseName);
    }
}

