/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.reflect.Proxy;
import org.aincraft.config.YamlConfiguration;
import org.bukkit.plugin.Plugin;

final class SingleYamlConfigurationImpl {
    private final Plugin plugin;
    private final String path;
    private org.bukkit.configuration.file.YamlConfiguration config;
    private File configFile;

    SingleYamlConfigurationImpl(Plugin plugin, String path) {
        this.plugin = plugin;
        this.path = path;
        this.configFile = new File(plugin.getDataFolder(), path);
        if (!this.configFile.exists()) {
            plugin.saveResource(path, false);
        }
        assert (this.configFile != null);
        this.config = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    static YamlConfiguration single(Plugin plugin, String path) throws IllegalArgumentException {
        String[] split = path.split("\\.");
        Preconditions.checkArgument((split.length >= 2 ? 1 : 0) != 0);
        String extension = split[1];
        Preconditions.checkArgument(("yml".equals(extension) || "yaml".equals(extension) ? 1 : 0) != 0);
        SingleYamlConfigurationImpl configuration = new SingleYamlConfigurationImpl(plugin, path);
        return (YamlConfiguration)Proxy.newProxyInstance(plugin.getClass().getClassLoader(), new Class[]{YamlConfiguration.class}, (proxy, method, args) -> method.invoke((Object)configuration.config, args));
    }
}

