/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft.math;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.random.RandomGenerator;
import org.aincraft.math.RandomSelector;

final class WeightedRandomSelectorImpl<T>
implements RandomSelector.WeightedRandomSelector<T> {
    private final List<Double> weights = new ArrayList<Double>();
    private final List<T> objects = new ArrayList<T>();
    private double cumulative = 0.0;

    WeightedRandomSelectorImpl() {
    }

    @Override
    public T getObject(RandomGenerator randomGenerator) throws IllegalStateException {
        Preconditions.checkState((this.objects.size() == this.weights.size() ? 1 : 0) != 0);
        Preconditions.checkState((!this.objects.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.cumulative > 0.0 ? 1 : 0) != 0);
        double random = randomGenerator.nextDouble(0.0, this.cumulative);
        int index = Collections.binarySearch(this.weights, random);
        if (index < 0) {
            index = -(index + 1);
        }
        return this.objects.get(index);
    }

    @Override
    public void addObject(double weight, T object) throws IllegalArgumentException {
        Preconditions.checkArgument((!Double.isNaN(weight) && weight >= 0.0 ? 1 : 0) != 0);
        this.objects.add(object);
        this.weights.add(this.cumulative += weight);
    }
}

