/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.defaults;

import java.net.URI;
import org.ajoberstar.gradle.defaults.MavenCentralExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugins.signing.SigningExtension;

public class MavenCentralConventionPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        MavenCentralExtension extension = (MavenCentralExtension)project.getExtensions().create("mavenCentral", MavenCentralExtension.class, new Object[0]);
        project.getPluginManager().apply("maven-publish");
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        this.configureRepositories(project, publishing);
        this.configurePom(project, publishing, extension);
        project.getPluginManager().apply("signing");
        SigningExtension signing = (SigningExtension)project.getExtensions().getByType(SigningExtension.class);
        this.enableSigning(project, signing);
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            java.withJavadocJar();
            java.withSourcesJar();
        });
    }

    private void configureRepositories(Project project, PublishingExtension publishing) {
        publishing.repositories(repos -> repos.maven(repo -> {
            repo.setName("CentralReleases");
            repo.setUrl(URI.create("https://oss.sonatype.org/service/local/staging/deploy/maven2/"));
            repo.credentials(creds -> {
                Provider username = project.getProviders().environmentVariable("OSSRH_USERNAME").forUseAtConfigurationTime();
                Provider password = project.getProviders().environmentVariable("OSSRH_PASSWORD").forUseAtConfigurationTime();
                creds.setUsername((String)username.getOrNull());
                creds.setPassword((String)password.getOrNull());
            });
        }));
    }

    private void configurePom(Project project, PublishingExtension publishing, MavenCentralExtension extension) {
        publishing.getPublications().withType(MavenPublication.class, publication -> {
            project.getPluginManager().withPlugin("java-base", plugin -> publication.versionMapping(mapping -> {
                mapping.usage("java-api", variant -> variant.fromResolutionOf("runtimeClasspath"));
                mapping.usage("java-runtime", VariantVersionMappingStrategy::fromResolutionResult);
            }));
            publication.pom(pom -> {
                pom.getName().set(project.provider(() -> ((Project)project).getName()));
                pom.getDescription().set(project.provider(() -> ((Project)project).getDescription()));
                pom.getUrl().set(extension.mapGitHubUrl("https://github.com/%s/%s"));
                pom.developers(devs -> devs.developer(dev -> {
                    dev.getName().set(extension.getDeveloperName());
                    dev.getEmail().set(extension.getDeveloperEmail());
                }));
                pom.licenses(licenses -> licenses.license(license -> {
                    license.getName().set((Object)"The Apache Software License, Version 2.0");
                    license.getUrl().set((Object)"http://www.apache.org/licenses/LICENSE-2.0");
                }));
                pom.scm(scm -> {
                    scm.getUrl().set(extension.mapGitHubUrl("https://github.com/%s/%s"));
                    scm.getConnection().set(extension.mapGitHubUrl("scm:git:git@github.com:%s/%s.git"));
                    scm.getDeveloperConnection().set(extension.mapGitHubUrl("scm:git:ssh:git@github.com:%s/%s.git"));
                });
            });
        });
    }

    private void enableSigning(Project project, SigningExtension signing) {
        Provider isCi = project.getProviders().environmentVariable("CI").forUseAtConfigurationTime();
        Provider signingKey = project.getProviders().gradleProperty("signingKey").forUseAtConfigurationTime();
        Provider signingPassphrase = project.getProviders().gradleProperty("signingPassphrase").forUseAtConfigurationTime();
        signing.setRequired(isCi.getOrNull());
        signing.useInMemoryPgpKeys((String)signingKey.getOrNull(), (String)signingPassphrase.getOrNull());
    }
}

