/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.defaults;

import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class MavenCentralExtension {
    private final Property<String> developerName;
    private final Property<String> developerEmail;
    private final Property<String> githubOwner;
    private final Property<String> githubRepository;

    @Inject
    public MavenCentralExtension(ObjectFactory objectFactory) {
        this.developerName = objectFactory.property(String.class);
        this.developerEmail = objectFactory.property(String.class);
        this.githubOwner = objectFactory.property(String.class);
        this.githubRepository = objectFactory.property(String.class);
    }

    public Property<String> getDeveloperName() {
        return this.developerName;
    }

    public Property<String> getDeveloperEmail() {
        return this.developerEmail;
    }

    public Property<String> getGithubOwner() {
        return this.githubOwner;
    }

    public Property<String> getGithubRepository() {
        return this.githubRepository;
    }

    Provider<String> mapGitHubUrl(String format) {
        return this.githubOwner.flatMap(owner -> this.githubRepository.map(repo -> String.format(format, owner, repo)));
    }
}

