/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.defaults;

import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class MavenCentralExtension {
    private final Property<String> developerName;
    private final Property<String> developerEmail;
    private final Property<String> forge;
    private final Property<String> owner;
    private final Property<String> repository;

    @Inject
    public MavenCentralExtension(ObjectFactory objectFactory) {
        this.developerName = objectFactory.property(String.class);
        this.developerEmail = objectFactory.property(String.class);
        this.forge = objectFactory.property(String.class).convention((Object)"github");
        this.owner = objectFactory.property(String.class);
        this.repository = objectFactory.property(String.class);
    }

    public Property<String> getDeveloperName() {
        return this.developerName;
    }

    public Property<String> getDeveloperEmail() {
        return this.developerEmail;
    }

    public Property<String> getForge() {
        return this.forge;
    }

    public Property<String> getOwner() {
        return this.owner;
    }

    public Property<String> getRepository() {
        return this.repository;
    }

    @Deprecated
    public Property<String> getGithubOwner() {
        return this.owner;
    }

    @Deprecated
    public Property<String> getGithubRepository() {
        return this.repository;
    }

    public Provider<String> getWebUrl() {
        Provider slug = this.owner.zip(this.repository, (o, r) -> "%s/%s".formatted(o, r));
        return this.forge.zip(slug, (f, s) -> switch (f) {
            case "github" -> "https://github.com/%s".formatted(s);
            case "sourcehut" -> "https://git.sr.ht/~%s".formatted(s);
            default -> throw new IllegalArgumentException("Invalid forge: %s".formatted(f));
        });
    }

    public Provider<String> getGitReadUrl() {
        Provider slug = this.owner.zip(this.repository, (o, r) -> "%s/%s".formatted(o, r));
        return this.forge.zip(slug, (f, s) -> switch (f) {
            case "github" -> "https://github.com/%s.git".formatted(s);
            case "sourcehut" -> "https://git.sr.ht/~%s".formatted(s);
            default -> throw new IllegalArgumentException("Invalid forge: %s".formatted(f));
        });
    }

    public Provider<String> getGitWriteUrl() {
        Provider slug = this.owner.zip(this.repository, (o, r) -> "%s/%s".formatted(o, r));
        return this.forge.zip(slug, (f, s) -> switch (f) {
            case "github" -> "git@github.com:%s".formatted(s);
            case "sourcehut" -> "git@git.sr.ht:~%s".formatted(s);
            default -> throw new IllegalArgumentException("Invalid forge: %s".formatted(f));
        });
    }
}

