package org.ajoberstar.gradle.defaults;

import javax.inject.Inject;

import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class MavenCentralExtension {
  private final Property<String> developerName;
  private final Property<String> developerEmail;
  private final Property<String> forge;
  private final Property<String> owner;
  private final Property<String> repository;

  @Inject
  public MavenCentralExtension(ObjectFactory objectFactory) {
    this.developerName = objectFactory.property(String.class);
    this.developerEmail = objectFactory.property(String.class);
    this.forge = objectFactory.property(String.class).convention("github");
    this.owner = objectFactory.property(String.class);
    this.repository = objectFactory.property(String.class);
  }

  public Property<String> getDeveloperName() {
    return developerName;
  }

  public Property<String> getDeveloperEmail() {
    return developerEmail;
  }

  public Property<String> getForge() {
    return forge;
  }

  public Property<String> getOwner() {
    return owner;
  }

  public Property<String> getRepository() {
    return repository;
  }

  @Deprecated
  public Property<String> getGithubOwner() {
    return owner;
  }

  @Deprecated
  public Property<String> getGithubRepository() {
    return repository;
  }

  public Provider<String> getWebUrl() {
    var slug = owner.zip(repository, (o, r) -> "%s/%s".formatted(o, r));

    return forge.zip(slug, (f, s) -> switch(f) {
        case "github":
          yield "https://github.com/%s".formatted(s);
        case "sourcehut":
          yield "https://git.sr.ht/~%s".formatted(s);
        default:
          throw new IllegalArgumentException("Invalid forge: %s".formatted(f));
      });
  }

  public Provider<String> getGitReadUrl() {
    var slug = owner.zip(repository, (o, r) -> "%s/%s".formatted(o, r));

    return forge.zip(slug, (f, s) -> switch(f) {
        case "github":
          yield "https://github.com/%s.git".formatted(s);
        case "sourcehut":
          yield "https://git.sr.ht/~%s".formatted(s);
        default:
          throw new IllegalArgumentException("Invalid forge: %s".formatted(f));
      });
  }

  public Provider<String> getGitWriteUrl() {
        var slug = owner.zip(repository, (o, r) -> "%s/%s".formatted(o, r));

        return forge.zip(slug, (f, s) -> switch(f) {
        case "github":
          yield "git@github.com:%s".formatted(s);
        case "sourcehut":
          yield "git@git.sr.ht:~%s".formatted(s);
        default:
          throw new IllegalArgumentException("Invalid forge: %s".formatted(f));
      });
  }
}
