/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.reckon.gradle;

import java.util.Optional;
import org.ajoberstar.grgit.Grgit;
import org.ajoberstar.reckon.core.Reckoner;
import org.ajoberstar.reckon.core.Version;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.gradle.api.Project;

public class ReckonExtension {
    private static final String SCOPE_PROP = "reckon.scope";
    private static final String STAGE_PROP = "reckon.stage";
    private static final String SNAPSHOT_PROP = "reckon.snapshot";
    private Project project;
    private Reckoner.Builder reckoner;

    public ReckonExtension(Project project, Grgit grgit) {
        this.project = project;
        this.reckoner = Reckoner.builder();
        Repository repo = Optional.ofNullable(grgit).map(Grgit::getRepository).map(org.ajoberstar.grgit.Repository::getJgit).map(Git::getRepository).orElse(null);
        this.reckoner.git(repo);
    }

    @Deprecated
    public void setNormal(ReckonExtension ext) {
        this.project.getLogger().warn("reckon.normal = scopeFromProp() is deprecated and will be removed in 1.0.0. Call reckon.scopeFromProp() instead.");
    }

    @Deprecated
    public void setPreRelease(ReckonExtension ext) {
        this.project.getLogger().warn("reckon.preRelease = stageFromProp() or snapshotFromProp() is deprecated and will be removed in 1.0.0. Call reckon.stageFromProp() or reckon.snapshotFromProp() instead.");
    }

    public ReckonExtension scopeFromProp() {
        this.reckoner.scopeCalc(inventory -> this.findProperty(SCOPE_PROP));
        return this;
    }

    public ReckonExtension stageFromProp(String ... stages) {
        this.reckoner.stages(stages);
        this.reckoner.stageCalc((inventory, targetNormal) -> this.findProperty(STAGE_PROP));
        return this;
    }

    public ReckonExtension snapshotFromProp() {
        this.reckoner.snapshots();
        this.reckoner.stageCalc((inventory, targetNormal) -> {
            Optional<String> stageProp = this.findProperty(STAGE_PROP);
            Optional<String> snapshotProp = this.findProperty(SNAPSHOT_PROP).map(Boolean::parseBoolean).map(isSnapshot -> isSnapshot != false ? "snapshot" : "final");
            snapshotProp.ifPresent(val -> this.project.getLogger().warn("Property {} is deprecated and will be removed in 1.0.0. Use {} set to one of [snapshot, final].", (Object)SNAPSHOT_PROP, (Object)STAGE_PROP));
            return stageProp.isPresent() ? stageProp : snapshotProp;
        });
        return this;
    }

    private Optional<String> findProperty(String name) {
        return Optional.ofNullable(this.project.findProperty(name)).filter(value -> this.project.getGradle().getParent() == null).map(Object::toString);
    }

    Version reckonVersion() {
        Version version = this.reckoner.build().reckon();
        this.project.getLogger().warn("Reckoned version: {}", (Object)version);
        return version;
    }
}

