/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.reckon.gradle;

import org.ajoberstar.grgit.gradle.GrgitService;
import org.ajoberstar.reckon.core.Version;
import org.ajoberstar.reckon.core.VersionTagParser;
import org.ajoberstar.reckon.core.VersionTagWriter;
import org.ajoberstar.reckon.gradle.ReckonCreateTagTask;
import org.ajoberstar.reckon.gradle.ReckonExtension;
import org.ajoberstar.reckon.gradle.ReckonPushTagTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class ReckonSettingsPlugin
implements Plugin<Settings> {
    public static final String TAG_TASK = "reckonTagCreate";
    public static final String PUSH_TASK = "reckonTagPush";
    private static final String SCOPE_PROP = "reckon.scope";
    private static final String STAGE_PROP = "reckon.stage";

    public void apply(Settings settings) {
        Provider grgitService = settings.getGradle().getSharedServices().registerIfAbsent("reckon-grgit", GrgitService.class, spec -> {
            ((GrgitService.Params)spec.getParameters()).getCurrentDirectory().set(settings.getSettingsDir());
            ((GrgitService.Params)spec.getParameters()).getInitIfNotExists().set((Object)false);
            spec.getMaxParallelUsages().set((Object)1);
        });
        ReckonExtension extension = (ReckonExtension)settings.getExtensions().create("reckon", ReckonExtension.class, new Object[0]);
        extension.getGrgitService().set(grgitService);
        extension.setTagParser(VersionTagParser.getDefault());
        extension.setTagWriter(VersionTagWriter.getDefault());
        extension.getTagMessage().convention(extension.getVersion().map(Version::toString));
        if (settings.getGradle().getParent() == null) {
            extension.getScope().set(settings.getProviders().gradleProperty(SCOPE_PROP).forUseAtConfigurationTime());
            extension.getStage().set(settings.getProviders().gradleProperty(STAGE_PROP).forUseAtConfigurationTime());
        }
        DelayedVersion sharedVersion = new DelayedVersion(extension.getVersion());
        settings.getGradle().allprojects(prj -> prj.setVersion((Object)sharedVersion));
        settings.getGradle().projectsLoaded(gradle -> {
            TaskProvider<ReckonCreateTagTask> tag = this.createTagTask(settings.getGradle().getRootProject(), extension);
            TaskProvider<ReckonPushTagTask> push = this.createPushTask(settings.getGradle().getRootProject(), extension);
            push.configure(t -> t.dependsOn(new Object[]{tag}));
        });
    }

    private TaskProvider<ReckonCreateTagTask> createTagTask(Project project, ReckonExtension extension) {
        return project.getTasks().register(TAG_TASK, ReckonCreateTagTask.class, task -> {
            task.setDescription("Tag version inferred by reckon.");
            task.setGroup("publishing");
            task.getGrgitService().set(extension.getGrgitService());
            task.getVersion().set(extension.getVersion());
            task.getTagWriter().set(extension.getTagWriter());
            task.getTagMessage().set(extension.getTagMessage());
        });
    }

    private TaskProvider<ReckonPushTagTask> createPushTask(Project project, ReckonExtension extension) {
        return project.getTasks().register(PUSH_TASK, ReckonPushTagTask.class, task -> {
            task.setDescription("Push version tag created by reckon.");
            task.setGroup("publishing");
            task.getGrgitService().set(extension.getGrgitService());
            task.getRemote().set(extension.getRemote());
            task.getVersion().set(extension.getVersion());
            task.getTagWriter().set(extension.getTagWriter());
        });
    }

    private static class DelayedVersion {
        private final Provider<Version> versionProvider;

        public DelayedVersion(Provider<Version> versionProvider) {
            this.versionProvider = versionProvider;
        }

        public String toString() {
            return ((Version)this.versionProvider.get()).toString();
        }
    }
}

