/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.reckon.gradle;

import java.io.File;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.ajoberstar.reckon.core.Reckoner;
import org.ajoberstar.reckon.core.Scope;
import org.ajoberstar.reckon.core.ScopeCalculator;
import org.ajoberstar.reckon.core.StageCalculator;
import org.ajoberstar.reckon.core.Version;
import org.ajoberstar.reckon.core.VersionTagParser;
import org.ajoberstar.reckon.core.VersionTagWriter;
import org.ajoberstar.reckon.gradle.ReckonConfigurationException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public class ReckonExtension {
    private static Logger logger = Logging.getLogger(ReckonExtension.class);
    private final DirectoryProperty repoDirectory;
    private final Reckoner.Builder reckonerBuilder;
    private final Property<String> scope;
    private final Property<String> stage;
    private final Property<Version> version;
    private final Property<String> remote;
    private VersionTagParser tagParser;
    private VersionTagWriter tagWriter;
    private final Provider<String> tagName;
    private final Property<String> tagMessage;

    @Inject
    public ReckonExtension(ObjectFactory objectFactory, ProviderFactory providerFactory) {
        this.repoDirectory = objectFactory.directoryProperty();
        this.reckonerBuilder = Reckoner.builder();
        this.scope = objectFactory.property(String.class);
        this.stage = objectFactory.property(String.class);
        this.version = objectFactory.property(Version.class);
        Provider versionProvider = providerFactory.provider(this::reckonVersion);
        this.version.set(versionProvider);
        this.version.disallowChanges();
        this.version.finalizeValueOnRead();
        this.remote = objectFactory.property(String.class);
        this.tagParser = null;
        this.tagWriter = null;
        this.tagName = this.version.map(v -> {
            if (this.tagWriter == null || !v.isSignificant()) {
                return null;
            }
            return this.tagWriter.write(v);
        });
        this.tagMessage = objectFactory.property(String.class);
    }

    public DirectoryProperty getRepoDirectory() {
        return this.repoDirectory;
    }

    public void setDefaultInferredScope(String scope) {
        this.setDefaultInferredScope(Scope.from((String)scope));
    }

    public void setDefaultInferredScope(Scope scope) {
        this.reckonerBuilder.defaultInferredScope(scope);
    }

    public void setParallelBranchScope(String scope) {
        this.setParallelBranchScope(Scope.from((String)scope));
    }

    public void setParallelBranchScope(Scope scope) {
        this.reckonerBuilder.parallelBranchScope(scope);
    }

    public void stages(String ... stages) {
        this.reckonerBuilder.stages(stages);
    }

    public void snapshots() {
        this.reckonerBuilder.snapshots();
    }

    public void setScopeCalc(ScopeCalculator scopeCalc) {
        this.reckonerBuilder.scopeCalc(scopeCalc);
    }

    public void setStageCalc(StageCalculator stageCalc) {
        this.reckonerBuilder.stageCalc(stageCalc);
    }

    public ScopeCalculator calcScopeFromProp() {
        return ScopeCalculator.ofUserString(inventory -> Optional.ofNullable((String)this.scope.getOrNull()));
    }

    public ScopeCalculator calcScopeFromCommitMessages() {
        return ScopeCalculator.ofCommitMessages();
    }

    public ScopeCalculator calcScopeFromCommitMessages(Function<String, Optional<Scope>> messageParser) {
        return ScopeCalculator.ofCommitMessage(messageParser);
    }

    public StageCalculator calcStageFromProp() {
        return StageCalculator.ofUserString((inventory, targetNormal) -> Optional.ofNullable((String)this.stage.getOrNull()));
    }

    @Deprecated
    public ReckonExtension scopeFromProp() {
        this.reckonerBuilder.scopeCalc(this.calcScopeFromProp());
        return this;
    }

    @Deprecated
    public ReckonExtension stageFromProp(String ... stages) {
        this.reckonerBuilder.stages(stages);
        this.reckonerBuilder.stageCalc(this.calcStageFromProp());
        return this;
    }

    @Deprecated
    public ReckonExtension snapshotFromProp() {
        this.reckonerBuilder.snapshots();
        this.reckonerBuilder.stageCalc(this.calcStageFromProp());
        return this;
    }

    public Property<String> getRemote() {
        return this.remote;
    }

    public void setTagParser(VersionTagParser tagParser) {
        this.tagParser = tagParser;
    }

    public Provider<String> getTagName() {
        return this.tagName;
    }

    public void setTagWriter(VersionTagWriter tagWriter) {
        this.tagWriter = tagWriter;
    }

    public Property<String> getTagMessage() {
        return this.tagMessage;
    }

    public Provider<Version> getVersion() {
        return this.version;
    }

    Property<String> getScope() {
        return this.scope;
    }

    Property<String> getStage() {
        return this.stage;
    }

    private Version reckonVersion() {
        try (Repository repo = this.openRepo();){
            Reckoner reckoner;
            this.reckonerBuilder.git(repo, this.tagParser);
            try {
                reckoner = this.reckonerBuilder.build();
            }
            catch (Exception e) {
                throw new ReckonConfigurationException("Failed to configure Reckon: " + e.getMessage(), e);
            }
            Version version = reckoner.reckon();
            logger.warn("Reckoned version: {}", (Object)version);
            Version version2 = version;
            return version2;
        }
    }

    private Repository openRepo() {
        try {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            builder.readEnvironment();
            builder.findGitDir((File)this.getRepoDirectory().getAsFile().get());
            if (builder.getGitDir() == null) {
                throw new IllegalStateException("No .git directory found!");
            }
            return builder.build();
        }
        catch (Exception e) {
            return null;
        }
    }
}

