/*
 * Decompiled with CFR 0.152.
 */
package org.ak80.att.akkatesttools;

import akka.AkkaException;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.InfoFilter;
import akka.testkit.JavaTestKit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import scala.Function0;
import scala.runtime.AbstractFunction0;

public class LogAssert {
    private final ActorSystem system;
    private ActorRef actorRef;
    private Runnable runnable;

    public LogAssert(ActorSystem system) {
        this.system = system;
    }

    public static void assertLogInfo(final Runnable runnable, final String message, final ActorRef actorRef, final ActorSystem system) {
        new JavaTestKit(system){
            {
                super(x0);
                InfoFilter filter = new InfoFilter(actorRef.path().toString(), message, true, false, 1);
                boolean result = (Boolean)filter.intercept((Function0)new AbstractFunction0<Boolean>(){

                    public Boolean apply() {
                        runnable.run();
                        return true;
                    }
                }, system);
                MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
            }
        };
    }

    public static void assertException(final Runnable runnable, final Class<? extends AkkaException> exception, final ActorRef actorRef, ActorSystem system) {
        new JavaTestKit(system){
            {
                super(x0);
                boolean result = (Boolean)new JavaTestKit.EventFilter<Boolean>(exception){

                    protected Boolean run() {
                        runnable.run();
                        return true;
                    }
                }.from(actorRef.path().toString()).occurrences(1).exec();
                MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
            }
        };
    }

    public void whenTell(ActorRef actorRef, Object message) {
        this.actorRef = actorRef;
        this.runnable = () -> actorRef.tell(message, ActorRef.noSender());
    }

    public void thenAssertLogInfo(String message) {
        LogAssert.assertLogInfo(this.runnable, message, this.actorRef, this.system);
    }

    public void thenAssertException(Class<? extends AkkaException> e) {
        LogAssert.assertException(this.runnable, e, this.actorRef, this.system);
    }
}

