/*
 * Decompiled with CFR 0.152.
 */
package org.ak80.bdp;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ak80.bdp.FileWriter;
import org.ak80.bdp.Generator;
import org.ak80.bdp.MappedClass;
import org.ak80.bdp.MappingGenerator;
import org.ak80.bdp.MappingInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/ak80/bdp/BdpGenerator;", "Lorg/ak80/bdp/Generator;", "fileWriter", "Lorg/ak80/bdp/FileWriter;", "(Lorg/ak80/bdp/FileWriter;)V", "classSuffix", "", "getClassSuffix", "()Ljava/lang/String;", "instanceField", "mappingGenerator", "Lorg/ak80/bdp/MappingGenerator;", "parseMethodPrefix", "getParseMethodPrefix", "serializeMethodPrefix", "getSerializeMethodPrefix", "createBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "kotlin.jvm.PlatformType", "className", "createParseMapping", "mappingInfo", "Lorg/ak80/bdp/MappingInfo;", "createSerializeMapping", "generateFor", "", "mappedClass", "Lorg/ak80/bdp/MappedClass;", "getGetterName", "getSetterName", "bdp-processor"})
public final class BdpGenerator
implements Generator {
    @NotNull
    private final String classSuffix = "Parser";
    @NotNull
    private final String parseMethodPrefix = "parse";
    @NotNull
    private final String serializeMethodPrefix = "serialize";
    private final MappingGenerator mappingGenerator;
    private String instanceField;
    private FileWriter fileWriter;

    @NotNull
    public final String getClassSuffix() {
        return this.classSuffix;
    }

    @NotNull
    public final String getParseMethodPrefix() {
        return this.parseMethodPrefix;
    }

    @NotNull
    public final String getSerializeMethodPrefix() {
        return this.serializeMethodPrefix;
    }

    @Override
    public void generateFor(@NotNull MappedClass mappedClass) {
        Intrinsics.checkParameterIsNotNull((Object)mappedClass, (String)"mappedClass");
        String parserClassName = mappedClass.getSimpleName() + this.classSuffix;
        this.instanceField = StringsKt.decapitalize((String)mappedClass.getSimpleName());
        StringBuilder parseMethodCode = new StringBuilder();
        StringBuilder serializeMethodCode = new StringBuilder();
        for (MappingInfo mappingInfo : mappedClass.getMappings()) {
            parseMethodCode.append(this.createParseMapping(mappingInfo));
            serializeMethodCode.append(this.createSerializeMapping(mappingInfo));
        }
        TypeSpec.Builder builder = this.createBuilder(parserClassName).addMethod(MethodSpec.methodBuilder((String)this.parseMethodPrefix).addParameter(TypeName.get((TypeMirror)mappedClass.getClassType()), this.instanceField, new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.INT), "data", new Modifier[0]).addCode(parseMethodCode.toString(), new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)this.serializeMethodPrefix).addParameter(TypeName.get((TypeMirror)mappedClass.getClassType()), this.instanceField, new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.INT), "data", new Modifier[0]).addCode(serializeMethodCode.toString(), new Object[0]).build());
        String string = mappedClass.getPackageName();
        TypeSpec.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        this.fileWriter.write(string, builder2);
    }

    private final TypeSpec.Builder createBuilder(String className) {
        return TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private final String createParseMapping(MappingInfo mappingInfo) {
        String setterName = this.getSetterName(mappingInfo);
        return this.mappingGenerator.getParseCode(mappingInfo, setterName);
    }

    private final String createSerializeMapping(MappingInfo mappingInfo) {
        String getterName = this.getGetterName(mappingInfo);
        return this.mappingGenerator.getSerializeCode(mappingInfo, getterName);
    }

    private final String getSetterName(MappingInfo mappingInfo) {
        return this.instanceField + ".set" + StringsKt.capitalize((String)mappingInfo.getName());
    }

    private final String getGetterName(MappingInfo mappingInfo) {
        return this.instanceField + ".get" + StringsKt.capitalize((String)mappingInfo.getName());
    }

    public BdpGenerator(@NotNull FileWriter fileWriter) {
        Intrinsics.checkParameterIsNotNull((Object)fileWriter, (String)"fileWriter");
        this.fileWriter = fileWriter;
        this.classSuffix = "Parser";
        this.parseMethodPrefix = "parse";
        this.serializeMethodPrefix = "serialize";
        this.mappingGenerator = new MappingGenerator();
        this.instanceField = "";
    }
}

