/*
 * Decompiled with CFR 0.152.
 */
package org.ak80.bdp;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.ak80.bdp.BdpProcessor;
import org.ak80.bdp.Generator;
import org.ak80.bdp.MappedClass;
import org.ak80.bdp.MappedClasses;
import org.ak80.bdp.annotations.MappedByte;
import org.ak80.bdp.annotations.MappedFlag;
import org.ak80.bdp.annotations.MappedWord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\b2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R(\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lorg/ak80/bdp/CoreProcessor;", "Lorg/ak80/bdp/BdpProcessor;", "mappedClasses", "Lorg/ak80/bdp/MappedClasses;", "generator", "Lorg/ak80/bdp/Generator;", "(Lorg/ak80/bdp/MappedClasses;Lorg/ak80/bdp/Generator;)V", "fieldMappingAnnotations", "", "Ljava/lang/Class;", "", "getFieldMappingAnnotations", "()Ljava/util/Set;", "setFieldMappingAnnotations", "(Ljava/util/Set;)V", "messager", "Ljavax/annotation/processing/Messager;", "getMessager", "()Ljavax/annotation/processing/Messager;", "messager$delegate", "Lkotlin/Lazy;", "processingEnvironment", "Ljavax/annotation/processing/ProcessingEnvironment;", "getProcessingEnvironment", "()Ljavax/annotation/processing/ProcessingEnvironment;", "setProcessingEnvironment", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "error", "", "element", "Ljavax/lang/model/element/Element;", "message", "", "getAnnotation", "getClassFullName", "getClassPackage", "fullName", "simpleName", "getClassSimpleName", "getMappedClass", "Lorg/ak80/bdp/MappedClass;", "init", "process", "", "annotations", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "processMappedField", "bdp-processor"})
public final class CoreProcessor
implements BdpProcessor {
    @NotNull
    private Set<? extends Class<? extends Annotation>> fieldMappingAnnotations;
    @Nullable
    private ProcessingEnvironment processingEnvironment;
    private final Lazy messager$delegate;
    private final MappedClasses mappedClasses;
    private final Generator generator;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    public final Set<Class<? extends Annotation>> getFieldMappingAnnotations() {
        return this.fieldMappingAnnotations;
    }

    public final void setFieldMappingAnnotations(@NotNull Set<? extends Class<? extends Annotation>> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.fieldMappingAnnotations = set;
    }

    @Nullable
    public final ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    public final void setProcessingEnvironment(@Nullable ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    private final Messager getMessager() {
        Lazy lazy = this.messager$delegate;
        CoreProcessor coreProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Messager)lazy.getValue();
    }

    @Override
    public void init(@NotNull ProcessingEnvironment processingEnvironment) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnvironment, (String)"processingEnvironment");
        this.processingEnvironment = processingEnvironment;
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        boolean exit;
        Element annotatedElement;
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)roundEnv, (String)"roundEnv");
        Iterator<Object> iterator = roundEnv.getElementsAnnotatedWith(MappedByte.class).iterator();
        while (iterator.hasNext()) {
            Element element = annotatedElement = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"annotatedElement");
            exit = this.processMappedField(element);
            if (!exit) continue;
            break;
        }
        iterator = roundEnv.getElementsAnnotatedWith(MappedWord.class).iterator();
        while (iterator.hasNext()) {
            Element element = annotatedElement = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"annotatedElement");
            exit = this.processMappedField(element);
            if (!exit) continue;
            break;
        }
        iterator = roundEnv.getElementsAnnotatedWith(MappedFlag.class).iterator();
        while (iterator.hasNext()) {
            Element element = annotatedElement = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"annotatedElement");
            exit = this.processMappedField(element);
            if (!exit) continue;
            break;
        }
        for (MappedClass byteMappedClass : this.mappedClasses.getClasses()) {
            this.generator.generateFor(byteMappedClass);
        }
        this.mappedClasses.clear();
        return true;
    }

    private final boolean processMappedField(Element element) {
        if (Intrinsics.areEqual((Object)((Object)element.getKind()), (Object)((Object)ElementKind.FIELD)) ^ true) {
            this.error(element, "Only fields can be annotated with mapping annotation");
            return true;
        }
        MappedClass mappedClass = this.getMappedClass(element);
        String fieldName = element.getSimpleName().toString();
        TypeMirror typeMirror = element.asType();
        String fieldType = typeMirror.getKind().name().toString();
        Annotation annotation = this.getAnnotation(element);
        mappedClass.addMapping(fieldName, fieldType, annotation);
        return false;
    }

    private final MappedClass getMappedClass(Element element) {
        TypeMirror parentType;
        String classFullName = this.getClassFullName(element);
        String classSimpleName = this.getClassSimpleName(element);
        String classPackage = this.getClassPackage(classFullName, classSimpleName);
        TypeMirror typeMirror = parentType = element.getEnclosingElement().asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"parentType");
        return this.mappedClasses.get(classSimpleName, classPackage, typeMirror);
    }

    private final Annotation getAnnotation(Element element) {
        Set annotations = SetsKt.mutableSetOf((Object[])new Annotation[0]);
        for (Class<? extends Annotation> clazz : this.fieldMappingAnnotations) {
            Annotation annotation = element.getAnnotation(clazz);
            if (annotation == null) continue;
            annotations = SetsKt.plus((Set)annotations, (Object)annotation);
        }
        if (annotations.size() > 1) {
            throw (Throwable)new IllegalStateException("Only one mapping annotation allowed for element " + element.getSimpleName() + " but found: " + annotations);
        }
        return (Annotation)CollectionsKt.single((Iterable)annotations);
    }

    private final String getClassFullName(Element element) {
        Element element2 = element.getEnclosingElement();
        if (element2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
        }
        TypeElement parentTypeElement = (TypeElement)element2;
        return parentTypeElement.getQualifiedName().toString();
    }

    private final String getClassSimpleName(Element element) {
        Element element2 = element.getEnclosingElement();
        if (element2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
        }
        TypeElement parentTypeElement = (TypeElement)element2;
        return parentTypeElement.getSimpleName().toString();
    }

    private final String getClassPackage(String fullName, String simpleName) {
        return ((Object)fullName.subSequence(0, fullName.length() - simpleName.length() - 1)).toString();
    }

    private final void error(Element element, String message) {
        this.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public CoreProcessor(@NotNull MappedClasses mappedClasses, @NotNull Generator generator) {
        Intrinsics.checkParameterIsNotNull((Object)mappedClasses, (String)"mappedClasses");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        this.mappedClasses = mappedClasses;
        this.generator = generator;
        this.fieldMappingAnnotations = SetsKt.setOf((Object[])new Class[]{MappedByte.class, MappedWord.class, MappedFlag.class});
        this.messager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Messager>(this){
            final /* synthetic */ CoreProcessor this$0;

            @NotNull
            public final Messager invoke() {
                Object object = this.this$0.getProcessingEnvironment();
                if (object == null || (object = object.getMessager()) == null) {
                    throw (Throwable)new IllegalStateException("the CoreProcessor was not initialized");
                }
                return object;
            }
            {
                this.this$0 = coreProcessor;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CoreProcessor.class), "messager", "getMessager()Ljavax/annotation/processing/Messager;"))};
    }
}

