package org.ak80.bdp;

import static org.ak80.bdp.BinaryUtils.*;
import static org.ak80.bdp.Bit.*;

public class TestClassParser {
  void parse(TestClass testClass, int[] data) {
    testClass.setByte0(data[0]);
    testClass.setByte1(data[1]);
    testClass.setWordBig((data[2] << BYTE_LENGTH) + data[3]);
    testClass.setWordLittle((data[5] << BYTE_LENGTH) + data[4]);
    testClass.setFlag0((data[6] & BIT_0.getMask()) == BIT_0.getMask());
    testClass.setFlag1((data[6] & BIT_4.getMask()) == BIT_4.getMask());
  }

  void serialize(TestClass testClass, int[] data) {
    data[0] = testClass.getByte0();
    data[1] = testClass.getByte1();
    data[2] = (testClass.getWordBig() >>> BYTE_LENGTH) & BYTE_MASK;
    data[3] = testClass.getWordBig() & BYTE_MASK;
    data[4] = testClass.getWordLittle() & BYTE_MASK;
    data[5] = (testClass.getWordLittle() >>> BYTE_LENGTH) & BYTE_MASK;
    if(testClass.isFlag0()) { data[6] = data[6] | BIT_0.getMask(); } else { data[6] = data[6] & ~BIT_0.getMask(); }
    if(testClass.isFlag1()) { data[6] = data[6] | BIT_4.getMask(); } else { data[6] = data[6] & ~BIT_4.getMask(); }
  }
}
