/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth.openid;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.aktin.broker.auth.openid.OpenIdAuthenticator;
import org.aktin.broker.auth.openid.OpenIdConfig;
import org.aktin.broker.server.auth.AbstractAuthProvider;
import org.aktin.broker.server.auth.HeaderAuthentication;

public class OpenIdAuthProvider
extends AbstractAuthProvider {
    private OpenIdConfig config;
    private OpenIdAuthenticator auth;

    public OpenIdAuthProvider() {
        this.config = null;
    }

    public OpenIdAuthProvider(InputStream in) {
        this.config = new OpenIdConfig(in);
    }

    private void loadConfig() throws IOException {
        if (this.config != null) {
            return;
        }
        try (InputStream in = Files.newInputStream(this.path.resolve("openid-config.properties"), new OpenOption[0]);){
            this.config = new OpenIdConfig(in);
        }
    }

    public HeaderAuthentication getInstance() throws IOException {
        if (this.auth == null) {
            this.loadConfig();
            this.auth = new OpenIdAuthenticator(this.config);
        }
        return new OpenIdAuthenticator(this.config);
    }

    public void setConfig(OpenIdConfig config) {
        this.config = config;
    }
}

