/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth.openid;

import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import org.aktin.broker.auth.openid.OpenIdConfig;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.AuthInfoImpl;
import org.aktin.broker.server.auth.AuthRole;
import org.aktin.broker.server.auth.HeaderAuthentication;
import org.aktin.broker.server.auth.HttpBearerAuthentication;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class OpenIdAuthenticator
implements HeaderAuthentication {
    public static final String KEY_JWT_USERNAME = "clientId";
    private final OpenIdConfig config;

    public OpenIdAuthenticator(OpenIdConfig config) {
        this.config = config;
    }

    public AuthInfo authenticateByHeaders(Function<String, String> getHeader) {
        Objects.requireNonNull(this.config);
        String accessTokenSerialized = HttpBearerAuthentication.extractBearerToken((String)getHeader.apply("Authorization"));
        try {
            JwtClaims jwtClaims = this.verifyToken(accessTokenSerialized);
            String userId = jwtClaims.getClaimValueAsString(KEY_JWT_USERNAME);
            String siteName = jwtClaims.getClaimValueAsString(this.config.getSiteNameClaim());
            HashSet<AuthRole> roles = new HashSet<AuthRole>();
            if (siteName != null && !siteName.isEmpty()) {
                roles.add(AuthRole.NODE_READ);
                roles.add(AuthRole.NODE_WRITE);
            } else {
                siteName = userId;
                roles.add(AuthRole.ADMIN_READ);
                roles.add(AuthRole.NODE_WRITE);
            }
            return new AuthInfoImpl(userId, "CN=" + siteName, roles);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private JwtClaims verifyToken(String accessTokenSerialized) throws IllegalAccessException {
        try {
            HttpsJwks httpsJwks = new HttpsJwks(this.config.getJwks_uri());
            HttpsJwksVerificationKeyResolver httpsJwksKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(10).setRequireSubject().setExpectedIssuer(this.config.getAuth_host()).setSkipDefaultAudienceValidation().setVerificationKeyResolver((VerificationKeyResolver)httpsJwksKeyResolver).setJwsAlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, this.config.getAllowedAlgorithms().toArray(new String[0])).build();
            return jwtConsumer.processToClaims(accessTokenSerialized);
        }
        catch (InvalidJwtException e) {
            throw new IllegalAccessException();
        }
    }
}

