/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth.openid;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class OpenIdConfig {
    private String jwks_uri;
    private String auth_host;
    private String siteNameClaim;
    private List<String> allowedAlgorithms;

    public OpenIdConfig(InputStream in) {
        Properties prop = new Properties();
        try {
            prop.load(in);
            this.setJwks_uri(prop.getProperty("openid.jwks_uri"));
            this.setAuth_host(prop.getProperty("openid.server"));
            this.setSiteNameClaim(prop.getProperty("openid.claim.site-name"));
            this.setAllowedAlgorithms(this.extractAlgorithmsList(prop.getProperty("openid.algorithms")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> extractAlgorithmsList(String algorithmsString) {
        List<String> algorithmsList = Arrays.asList(algorithmsString.split(","));
        return algorithmsList.stream().map(String::trim).collect(Collectors.toList());
    }

    public String getJwks_uri() {
        return this.jwks_uri;
    }

    public String getAuth_host() {
        return this.auth_host;
    }

    public String getSiteNameClaim() {
        return this.siteNameClaim;
    }

    public List<String> getAllowedAlgorithms() {
        return this.allowedAlgorithms;
    }

    public void setJwks_uri(String jwks_uri) {
        this.jwks_uri = jwks_uri;
    }

    public void setAuth_host(String auth_host) {
        this.auth_host = auth_host;
    }

    public void setSiteNameClaim(String siteNameClaim) {
        this.siteNameClaim = siteNameClaim;
    }

    public void setAllowedAlgorithms(List<String> allowedAlgorithms) {
        this.allowedAlgorithms = allowedAlgorithms;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenIdConfig)) {
            return false;
        }
        OpenIdConfig other = (OpenIdConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jwks_uri = this.getJwks_uri();
        String other$jwks_uri = other.getJwks_uri();
        if (this$jwks_uri == null ? other$jwks_uri != null : !this$jwks_uri.equals(other$jwks_uri)) {
            return false;
        }
        String this$auth_host = this.getAuth_host();
        String other$auth_host = other.getAuth_host();
        if (this$auth_host == null ? other$auth_host != null : !this$auth_host.equals(other$auth_host)) {
            return false;
        }
        String this$siteNameClaim = this.getSiteNameClaim();
        String other$siteNameClaim = other.getSiteNameClaim();
        if (this$siteNameClaim == null ? other$siteNameClaim != null : !this$siteNameClaim.equals(other$siteNameClaim)) {
            return false;
        }
        List<String> this$allowedAlgorithms = this.getAllowedAlgorithms();
        List<String> other$allowedAlgorithms = other.getAllowedAlgorithms();
        return !(this$allowedAlgorithms == null ? other$allowedAlgorithms != null : !((Object)this$allowedAlgorithms).equals(other$allowedAlgorithms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenIdConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jwks_uri = this.getJwks_uri();
        result = result * 59 + ($jwks_uri == null ? 43 : $jwks_uri.hashCode());
        String $auth_host = this.getAuth_host();
        result = result * 59 + ($auth_host == null ? 43 : $auth_host.hashCode());
        String $siteNameClaim = this.getSiteNameClaim();
        result = result * 59 + ($siteNameClaim == null ? 43 : $siteNameClaim.hashCode());
        List<String> $allowedAlgorithms = this.getAllowedAlgorithms();
        result = result * 59 + ($allowedAlgorithms == null ? 43 : ((Object)$allowedAlgorithms).hashCode());
        return result;
    }

    public String toString() {
        return "OpenIdConfig(jwks_uri=" + this.getJwks_uri() + ", auth_host=" + this.getAuth_host() + ", siteNameClaim=" + this.getSiteNameClaim() + ", allowedAlgorithms=" + this.getAllowedAlgorithms() + ")";
    }
}

