/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.server.auth;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.AuthRole;
import org.aktin.broker.server.auth.HeaderAuthentication;

public abstract class HttpBearerAuthentication
implements HeaderAuthentication {
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final Logger log = Logger.getLogger(HttpBearerAuthentication.class.getName());

    protected abstract AuthInfo lookupAuthInfo(String var1) throws IOException;

    public static String extractBearerToken(String authorizationHeader) {
        String key = null;
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
            key = authorizationHeader.substring(7);
        }
        return key;
    }

    public static Set<AuthRole> defaultRolesForClientDN(String clientDn) {
        if (clientDn == null) {
            return null;
        }
        if (clientDn.contains("OU=admin")) {
            return new HashSet<AuthRole>(Arrays.asList(AuthRole.ADMIN_READ, AuthRole.ADMIN_WRITE));
        }
        return new HashSet<AuthRole>(Arrays.asList(AuthRole.NODE_READ, AuthRole.NODE_WRITE));
    }

    @Override
    public AuthInfo authenticateByHeaders(Function<String, String> getHeader) throws IOException {
        String key = HttpBearerAuthentication.extractBearerToken(getHeader.apply(HTTP_HEADER_AUTHORIZATION));
        if (key == null) {
            log.info("HTTP Authorization header missing");
            return null;
        }
        return this.lookupAuthInfo(key);
    }
}

