/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.xml;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.aktin.broker.xml.RequestStatusInfo;

@XmlRootElement(name="request")
public class RequestInfo {
    @XmlAttribute
    int id;
    @XmlElement
    public Instant published;
    @XmlElement
    public Instant closed;
    @XmlElement
    public boolean targeted;
    @XmlElement(name="type")
    public String[] types;
    @XmlElement(name="node-status")
    public List<RequestStatusInfo> nodeStatus;

    public int getId() {
        return this.id;
    }

    protected RequestInfo() {
    }

    public RequestInfo(int id, Instant published, Instant closed, boolean targeted) {
        this.id = id;
        this.published = published;
        this.closed = closed;
        this.targeted = targeted;
    }

    public void setTypes(String[] types) {
        this.types = types;
    }

    public boolean hasMediaType(String type) {
        return Arrays.asList(this.types).contains(type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.closed == null ? 0 : this.closed.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.published == null ? 0 : this.published.hashCode());
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestInfo other = (RequestInfo)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.closed, other.closed)) {
            return false;
        }
        if (!Objects.equals(this.published, other.published)) {
            return false;
        }
        return Arrays.equals(this.types, other.types);
    }
}

