/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.auth.CascadedAuthProvider;
import org.aktin.broker.server.auth.AuthProvider;

public class DefaultConfiguration
implements Configuration {
    private static final String DEFAULT_AUTH_PROVIDER = "org.aktin.broker.auth.apikey.ApiKeyPropertiesAuthProvider,org.aktin.broker.auth.cred.CredentialTokenAuthProvider";
    private AuthProvider authProvider;

    public DefaultConfiguration() {
        String ap = System.getProperty("broker.auth.provider", DEFAULT_AUTH_PROVIDER);
        String[] aps = ap.split(",");
        if (aps.length == 1) {
            this.authProvider = this.loadProviderClass(aps[0]);
        } else {
            AuthProvider[] provs = new AuthProvider[aps.length];
            for (int i = 0; i < provs.length; ++i) {
                provs[i] = this.loadProviderClass(aps[i].trim());
            }
            this.authProvider = new CascadedAuthProvider(Arrays.asList(provs));
        }
    }

    private AuthProvider loadProviderClass(String name) throws IllegalArgumentException {
        try {
            Constructor<?> c = Class.forName(name).getConstructor(new Class[0]);
            return (AuthProvider)c.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to instantiate auth provider class: " + name, e);
        }
    }

    @Override
    public int getPort() {
        return 8080;
    }

    @Override
    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public Path getBasePath() {
        return Paths.get(".", new String[0]);
    }
}

