/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.rest.Authenticated;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.HeaderAuthentication;

@Authenticated
@Provider
@Priority(value=1000)
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    @Inject
    private AuthCache cache;
    @Inject
    private HeaderAuthentication auth;

    public void filter(ContainerRequestContext ctx) throws IOException {
        Objects.requireNonNull(this.auth, "injection of HeaderAuthentication failed");
        Objects.requireNonNull(this.cache, "injection of AuthCache failed");
        AuthInfo info = this.auth.authenticateByHeaders(arg_0 -> ((ContainerRequestContext)ctx).getHeaderString(arg_0));
        if (info == null) {
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return;
        }
        Principal user = this.cache.getPrincipal(info);
        ctx.setSecurityContext((SecurityContext)user);
    }
}

