/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.db;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestCalculatingInputStream
extends InputStream {
    private MessageDigest[] md;
    private InputStream source;
    private byte[][] digest;

    public DigestCalculatingInputStream(InputStream source, String[] algorithms) throws NoSuchAlgorithmException {
        this.source = source;
        this.md = new MessageDigest[algorithms.length];
        for (int i = 0; i < algorithms.length; ++i) {
            this.md[i] = MessageDigest.getInstance(algorithms[i]);
        }
    }

    public byte[][] getDigests() {
        return this.digest;
    }

    private void updateDigests(byte[] data, int off, int len) {
        for (int i = 0; i < this.md.length; ++i) {
            this.md[i].update(data, off, len);
        }
    }

    private void updateDigests(byte data) {
        for (int i = 0; i < this.md.length; ++i) {
            this.md[i].update(data);
        }
    }

    private void calculateDigests() {
        this.digest = new byte[this.md.length][];
        for (int i = 0; i < this.md.length; ++i) {
            this.digest[i] = this.md[i].digest();
        }
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public void close() throws IOException {
        if (this.digest == null) {
            this.calculateDigests();
        }
        this.source.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] dest, int off, int len) throws IOException {
        int cb = this.source.read(dest, off, len);
        if (cb > 0) {
            this.updateDigests(dest, off, cb);
        } else if (cb == -1 && this.digest == null) {
            this.calculateDigests();
        }
        return cb;
    }

    @Override
    public int read(byte[] dest) throws IOException {
        int cb = this.source.read(dest);
        if (cb > 0) {
            this.updateDigests(dest, 0, cb);
        } else if (cb == -1 && this.digest == null) {
            this.calculateDigests();
        }
        return cb;
    }

    @Override
    public long skip(long arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int b = this.source.read();
        if (b != -1) {
            this.updateDigests((byte)b);
        } else if (this.digest == null) {
            this.calculateDigests();
        }
        return b;
    }
}

