/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.rest.AbstractRequestEndpoint;
import org.aktin.broker.rest.Authenticated;
import org.aktin.broker.util.RequestTypeManager;
import org.aktin.broker.websocket.RequestAdminWebsocket;
import org.aktin.broker.xml.Node;
import org.aktin.broker.xml.RequestInfo;
import org.aktin.broker.xml.RequestList;
import org.aktin.broker.xml.RequestStatus;

@Authenticated
@Path(value="/broker/my/")
public class MyBrokerEndpoint
extends AbstractRequestEndpoint {
    private static final Logger log = Logger.getLogger(MyBrokerEndpoint.class.getName());
    @Inject
    private BrokerBackend db;
    @Inject
    private RequestTypeManager typeManager;

    @PUT
    @Path(value="node/{resource}")
    public void setNodesResource(@PathParam(value="resource") String resourceId, @Context HttpHeaders headers, @Context SecurityContext sec, InputStream content) {
        Principal user = (Principal)sec.getUserPrincipal();
        int nodeId = user.getNodeId();
        log.info("Resource uploaded by node " + nodeId + ": " + resourceId);
        try {
            this.db.updateNodeResource(user.getNodeId(), resourceId, headers.getMediaType(), content);
            RequestAdminWebsocket.broadcastNodeResourceChange(nodeId, resourceId);
        }
        catch (IOException | SQLException e) {
            log.log(Level.SEVERE, "Unable to write resource for node " + user.getNodeId() + ": " + resourceId, e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="node")
    @Produces(value={"application/xml"})
    public Node getOwnNodeInfo(@Context SecurityContext sec) {
        Principal user = (Principal)sec.getUserPrincipal();
        try {
            return this.db.getNode(user.getNodeId());
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to read node info for nodeId=" + user.getNodeId(), e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="request")
    @Produces(value={"application/xml"})
    public RequestList listNodesRequests(@Context SecurityContext sec) {
        Principal user = (Principal)sec.getUserPrincipal();
        try {
            return new RequestList(this.db.listRequestsForNode(user.getNodeId()));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to read requests for nodeId=" + user.getNodeId(), e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @OPTIONS
    @Path(value="request/{id}")
    public RequestInfo getNodesRequestInfo(@PathParam(value="id") Integer requestId, @Context SecurityContext sec, @Context HttpHeaders headers) throws SQLException, IOException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        if (info == null) {
            throw new NotFoundException("No request with id " + requestId);
        }
        return info;
    }

    @GET
    @Path(value="request/{id}")
    public Response getNodesRequest(@PathParam(value="id") Integer requestId, @Context SecurityContext sec, @Context HttpHeaders headers) throws SQLException, IOException {
        List accept = headers.getAcceptableMediaTypes();
        Response resp = this.getRequest(requestId, accept);
        return resp;
    }

    @POST
    @Path(value="request/{id}/status/{status}")
    public Response putNodesRequestError(@PathParam(value="id") Integer requestId, @PathParam(value="status") RequestStatus status, @Context SecurityContext sec, @Context HttpHeaders headers, Reader content) {
        Principal user = (Principal)sec.getUserPrincipal();
        Date date = headers.getDate();
        if (date == null) {
            date = new Date();
        }
        try {
            this.db.setRequestNodeStatus(requestId, user.getNodeId(), status, date.toInstant());
            if (headers.getMediaType() != null) {
                MediaType messageType = MyBrokerEndpoint.removeCharsetInfo(headers.getMediaType());
                this.db.setRequestNodeStatusMessage(requestId, user.getNodeId(), messageType.toString(), content);
            }
            content.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to update status for requestId=" + requestId + " for nodeId=" + user.getNodeId(), e);
            return Response.serverError().build();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to close content reader", e);
        }
        RequestAdminWebsocket.broadcastRequestNodeStatus(requestId, user.getNodeId(), status.name());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="request/{id}")
    public void deleteNodesRequest(@PathParam(value="id") String requestId, @Context SecurityContext sec) {
        Principal user = (Principal)sec.getUserPrincipal();
        boolean delete_ok = false;
        try {
            delete_ok = this.db.markRequestDeletedForNode(user.getNodeId(), Integer.parseInt(requestId));
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, "Unable to parse request id=" + requestId, e);
            delete_ok = false;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to delete requestId=" + requestId + " for nodeId=" + user.getNodeId(), e);
            throw new InternalServerErrorException();
        }
        if (!delete_ok) {
            throw new NotFoundException();
        }
    }

    @Override
    protected RequestTypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    protected BrokerBackend getBroker() {
        return this.db;
    }
}

