/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.AuthInfoImpl;
import org.aktin.broker.server.auth.AuthRole;
import org.aktin.broker.server.auth.HeaderAuthentication;

public class AuthFilterSSLHeaders
implements HeaderAuthentication {
    private static final Logger log = Logger.getLogger(AuthFilterSSLHeaders.class.getName());
    public static final String X_SSL_CLIENT_ID = "X-SSL-Client-ID";
    public static final String X_SSL_CLIENT_DN = "X-SSL-Client-DN";
    public static final String X_SSL_CLIENT_VERIFY = "X-SSL-Client-Verify";

    public Set<AuthRole> loadRolesFromClientDN(String clientDN) {
        if (clientDN.contains("OU=admin")) {
            return new HashSet<AuthRole>(Arrays.asList(AuthRole.ADMIN_READ, AuthRole.ADMIN_WRITE));
        }
        return new HashSet<AuthRole>(Arrays.asList(AuthRole.NODE_READ, AuthRole.NODE_WRITE));
    }

    public AuthInfo authenticateByHeaders(Function<String, String> getHeader) throws IOException {
        String verify = getHeader.apply(X_SSL_CLIENT_VERIFY);
        String id = getHeader.apply(X_SSL_CLIENT_ID);
        String dn = getHeader.apply(X_SSL_CLIENT_DN);
        if (verify == null || !verify.equals("SUCCESS")) {
            log.info("Client verify header not found or not successful");
            return null;
        }
        log.info("Authenticated user " + id + " with dn " + dn);
        return new AuthInfoImpl(id, dn, this.loadRolesFromClientDN(dn));
    }
}

