/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.websocket;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.aktin.broker.auth.Principal;

public abstract class AbstractBroadcastWebsocket {
    private static final Logger log = Logger.getLogger(AbstractBroadcastWebsocket.class.getName());

    protected abstract boolean isAuthorized(Principal var1);

    protected abstract void addSession(Session var1, Principal var2);

    protected abstract void removeSession(Session var1, Principal var2);

    @OnOpen
    public void open(Session session) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        log.log(Level.INFO, "Session id {} created for user {}", new Object[]{session.getId(), Objects.toString(user)});
        if (this.isAuthorized(user)) {
            this.addSession(session, user);
        } else {
            try {
                session.close();
                return;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close session", e);
            }
        }
        try {
            session.getBasicRemote().sendText("welcome " + user.getName());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to send welcome message", e);
        }
    }

    @OnClose
    public void close(Session session) {
        this.removeSession(session, AbstractBroadcastWebsocket.getSessionPrincipal(session));
        log.info("Session closed: " + session.getId());
    }

    @OnMessage
    public void message(Session session, String message) {
        Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
        log.log(Level.INFO, "Ignoring message from client {}", user.getName());
    }

    static int broadcast(Set<Session> clients, String message) {
        return AbstractBroadcastWebsocket.broadcast(clients, message, p -> true);
    }

    static int broadcast(Set<Session> clients, String message, Predicate<Principal> principalFilter) {
        Objects.requireNonNull(principalFilter);
        if (clients.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (Session session : clients) {
            Principal user = AbstractBroadcastWebsocket.getSessionPrincipal(session);
            if (user == null) {
                log.warning("Skipping websocket session without authentication " + session);
                continue;
            }
            if (!principalFilter.test(user) || !session.isOpen()) continue;
            session.getAsyncRemote().sendText(message);
            ++count;
        }
        return count;
    }

    protected static Principal getSessionPrincipal(Session session) {
        return (Principal)session.getUserProperties().get("auth-user");
    }
}

