/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth.apikey;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.aktin.broker.server.auth.AuthInfo;
import org.aktin.broker.server.auth.AuthInfoImpl;
import org.aktin.broker.server.auth.HttpBearerAuthentication;

public class PropertyFileAPIKeys
extends HttpBearerAuthentication {
    private static final Logger log = Logger.getLogger(PropertyFileAPIKeys.class.getName());
    private Properties properties = new Properties();

    public PropertyFileAPIKeys(InputStream in) throws IOException {
        this.properties.load(in);
        log.info("Loaded " + this.properties.size() + " client API keys");
    }

    protected AuthInfo lookupAuthInfo(String token) throws IOException {
        String clientDn = this.properties.getProperty(token);
        if (clientDn == null) {
            return null;
        }
        return new AuthInfoImpl(token, clientDn, HttpBearerAuthentication.defaultRolesForClientDN((String)clientDn));
    }
}

