/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth.cred;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.aktin.broker.auth.cred.Credentials;
import org.aktin.broker.auth.cred.Status;
import org.aktin.broker.auth.cred.Token;
import org.aktin.broker.auth.cred.TokenManager;
import org.aktin.broker.rest.Authenticated;
import org.aktin.broker.rest.RequireAdmin;
import org.aktin.broker.server.auth.HttpBearerAuthentication;

@Path(value="auth")
public class AuthEndpoint {
    private static final Logger log = Logger.getLogger(AuthEndpoint.class.getName());
    @Inject
    private TokenManager tokens;

    @POST
    @Path(value="login")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml"})
    public String authenticateUser(Credentials cred) {
        Token t = this.tokens.authenticate(cred.username, cred.password.toCharArray());
        if (t != null) {
            log.log(Level.INFO, "Login successful: {0}", cred.username);
            return t.getGUID();
        }
        log.log(Level.INFO, "Access denied for {0}", cred.username);
        throw new ClientErrorException(Response.Status.UNAUTHORIZED);
    }

    private Token resolveTokenFromBearerHeader(String bearer) throws ClientErrorException {
        String key = HttpBearerAuthentication.extractBearerToken((String)bearer);
        if (key == null) {
            throw new ClientErrorException(Response.Status.BAD_REQUEST);
        }
        Token token = this.tokens.lookupToken(key);
        if (token == null) {
            throw new ClientErrorException(Response.Status.BAD_REQUEST);
        }
        return token;
    }

    @GET
    @Authenticated
    @RequireAdmin
    @Path(value="status")
    @Produces(value={"application/xml"})
    public Status getStatus(@HeaderParam(value="Authorization") String bearer) {
        Token t = this.resolveTokenFromBearerHeader(bearer);
        Status s = new Status();
        s.issued = t.issuedTimeMillis();
        return s;
    }

    @POST
    @Authenticated
    @RequireAdmin
    @Path(value="logout")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String logout(@HeaderParam(value="Authorization") String bearer) {
        Token t = this.resolveTokenFromBearerHeader(bearer);
        t.invalidate();
        return "{duration=" + (System.currentTimeMillis() - t.issuedTimeMillis()) + "}";
    }
}

