/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth.cred;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.aktin.broker.auth.cred.Token;

@Singleton
public class TokenManager {
    public static final String PROPERTY_BROKER_PASSWORD = "aktin.broker.password";
    private static final Logger log = Logger.getLogger(TokenManager.class.getName());
    private Map<String, Token> map = new HashMap<String, Token>();
    private BiFunction<String, String, Boolean> authenticator;

    public TokenManager(String simplePassword) {
        this.authenticator = (login, password) -> password.contentEquals(simplePassword);
    }

    public TokenManager() {
        String simplePassword = System.getProperty(PROPERTY_BROKER_PASSWORD, TokenManager.randomPassword());
        System.err.println("Using password: " + simplePassword);
        log.info("Using password: " + simplePassword);
        this.authenticator = (login, password) -> password.contentEquals(simplePassword);
        this.map = new HashMap<String, Token>();
    }

    public static final String randomPassword() {
        StringBuilder b = new StringBuilder(8);
        for (int i = 0; i < b.capacity(); ++i) {
            b.append(Character.valueOf((char)(48.0 + Math.random() * 74.0)));
        }
        return b.toString();
    }

    Token authenticate(String username, char[] charArray) {
        if (!this.authenticator.apply(username, new String(charArray)).booleanValue()) {
            return null;
        }
        Token t = new Token(username);
        this.map.put(t.getGUID(), t);
        return t;
    }

    public Token lookupToken(String guid) {
        return this.map.get(guid);
    }
}

