/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.auth;

import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.admin.auth.Credentials;
import org.aktin.broker.admin.auth.Status;
import org.aktin.broker.admin.auth.Token;
import org.aktin.broker.admin.auth.TokenManager;

@Path(value="auth")
public class AuthEndpoint {
    private static final Logger log = Logger.getLogger(AuthEndpoint.class.getName());
    @Inject
    private TokenManager tokens;
    @Context
    private SecurityContext security;

    @POST
    @Path(value="login")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml"})
    public Response authenticateUser(Credentials cred) {
        Token t = this.tokens.authenticate(cred.username, cred.password.toCharArray());
        if (t != null) {
            log.info("Login successful: " + cred.username);
            return Response.ok((Object)t.getGUID()).build();
        }
        log.info("Access denied for " + cred.username);
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @RequireAdmin
    @Path(value="status")
    @Produces(value={"application/xml"})
    public Status getStatus(@Context SecurityContext sc) {
        Token t = (Token)sc.getUserPrincipal();
        Status s = new Status();
        s.issued = t.issuedTimeMillis();
        return s;
    }

    @POST
    @RequireAdmin
    @Path(value="logout")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String logout(@Context SecurityContext sc) {
        Token t = (Token)sc.getUserPrincipal();
        t.invalidate();
        return "{duration=" + (System.currentTimeMillis() - t.issuedTimeMillis()) + "}";
    }
}

