/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="template")
public class FormTemplateEndpoint {
    private static final Logger log = Logger.getLogger(FormTemplateEndpoint.class.getName());

    @GET
    @Produces(value={"application/json"})
    public String listTemplates() throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("{\n");
        String templateRoot = "/webapp/template";
        URL templateUrl = this.getClass().getResource(templateRoot + "/index.txt");
        if (templateUrl == null) {
            log.severe("Template resource folder not found");
            throw new NotFoundException();
        }
        try (InputStream in = templateUrl.openStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String name;
            boolean firstTemplate = true;
            while ((name = r.readLine()) != null) {
                if (name.trim().length() == 0 || name.startsWith("#")) continue;
                Properties props = new Properties();
                URL purl = this.getClass().getResource(templateRoot + "/" + name + "/template.properties");
                try {
                    InputStream pin = purl.openStream();
                    Throwable throwable = null;
                    try {
                        if (pin == null) continue;
                        props.load(pin);
                        if (!firstTemplate) {
                            b.append(",\n");
                        }
                        firstTemplate = false;
                        b.append("\t\"").append(name).append("\": {");
                        boolean firstProp = true;
                        for (String key : props.stringPropertyNames()) {
                            if (!firstProp) {
                                b.append(", ");
                            }
                            firstProp = false;
                            b.append("\"").append(key).append("\": \"").append(props.getProperty(key)).append("\"");
                        }
                        b.append("}");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pin == null) continue;
                        if (throwable != null) {
                            try {
                                pin.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pin.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Error loading form template properties", e);
                }
            }
        }
        b.append("\n}");
        return b.toString();
    }

    @GET
    @Path(value="script")
    public Response getScript(@QueryParam(value="mediaType") String mediaType) {
        return null;
    }
}

