/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.admin.auth.Token;
import org.aktin.broker.admin.auth.TokenManager;

@RequireAdmin
@Provider
@Priority(value=1000)
public class AuthFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(AuthFilter.class.getName());
    @Inject
    private TokenManager tokens;

    public void filter(ContainerRequestContext ctx) throws IOException {
        String authHeader = ctx.getHeaderString("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            throw new NotAuthorizedException((Object)"Authorization header must be provided", new Object[0]);
        }
        String token = authHeader.substring("Bearer".length()).trim();
        try {
            log.info("Authentication token: " + token);
            Token t = this.validateToken(token);
            t.renew();
            ctx.setSecurityContext(this.getSecurityContext(t));
        }
        catch (Exception e) {
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private Token validateToken(String token) throws IOException {
        Token t = this.tokens.lookupToken(token);
        if (t == null) {
            log.info("Token not found: " + token);
            throw new IOException("Access denied");
        }
        log.info("Token found, user=" + t.getName());
        return t;
    }

    private SecurityContext getSecurityContext(final Token token) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                if (role.equals("admin")) {
                    return token.isAdmin();
                }
                return token.hasRole(role);
            }

            public boolean isSecure() {
                return false;
            }

            public Principal getUserPrincipal() {
                return token;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }
}

