/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.io.IOException;
import java.nio.file.Paths;
import javax.sql.DataSource;
import org.aktin.broker.RequestTypeManager;
import org.aktin.broker.admin.auth.TokenManager;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.AggregatorImpl;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.BrokerImpl;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class MyBinder
extends AbstractBinder {
    private DataSource ds;
    private Configuration config;
    private BrokerBackend broker;
    private AggregatorBackend aggregator;

    public MyBinder(DataSource ds, Configuration config) {
        this.ds = ds;
        this.config = config;
    }

    protected void configure() {
        try {
            this.broker = new BrokerImpl(this.ds, Paths.get(this.config.getBrokerDataPath(), new String[0]));
            this.aggregator = new AggregatorImpl(this.ds, Paths.get(this.config.getAggregatorDataPath(), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bind(this.broker).to(BrokerBackend.class);
        this.bind(this.aggregator).to(AggregatorBackend.class);
        this.bind(new AuthCache(this.broker)).to(AuthCache.class);
        this.bind(new RequestTypeManager()).to(RequestTypeManager.class);
        this.bind(new TokenManager()).to(TokenManager.class);
    }
}

