/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import org.aktin.broker.Broker;
import org.aktin.broker.admin.auth.AuthEndpoint;
import org.aktin.broker.admin.auth.AuthFilter;
import org.aktin.broker.admin.rest.FormTemplateEndpoint;
import org.aktin.broker.admin.rest.ValidatorEndpoint;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.admin.standalone.DefaultConfiguration;
import org.aktin.broker.admin.standalone.HSQLDataSource;
import org.aktin.broker.admin.standalone.MyBinder;
import org.aktin.broker.admin.standalone.PropertyFileAPIKeys;
import org.aktin.broker.db.BrokerImpl;
import org.aktin.broker.db.LiquibaseWrapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class HttpServer {
    private Configuration config;
    private ResourceConfig rc;
    private Server jetty;
    private DataSource ds;
    private MyBinder binder;

    public HttpServer(Configuration config) throws SQLException, IOException {
        PropertyFileAPIKeys keys;
        this.config = config;
        this.ds = new HSQLDataSource(config.getDatabasePath());
        this.initialiseDatabase();
        this.rc = new ResourceConfig();
        try (InputStream in = config.readAPIKeyProperties();){
            keys = new PropertyFileAPIKeys(in);
        }
        if (System.getProperty("rewriteNodeDN") != null) {
            int count = BrokerImpl.updatePrincipalDN((DataSource)this.ds, keys.getMap());
            System.out.println("Rewritten " + count + " node DN strings.");
        }
        this.rc.register((Object)keys);
        this.rc.registerClasses(Broker.ENDPOINTS);
        this.rc.register(AuthFilter.class);
        this.rc.register(AuthEndpoint.class);
        this.rc.register(ValidatorEndpoint.class);
        this.rc.register(FormTemplateEndpoint.class);
    }

    private void initialiseDatabase() throws SQLException {
        try (LiquibaseWrapper w = new LiquibaseWrapper(this.ds.getConnection());){
            w.update();
        }
        catch (LiquibaseException e) {
            throw new SQLException("Unable to initialise database", e);
        }
    }

    protected void start_local(int port) throws Exception {
        this.start(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
    }

    public URI getBrokerServiceURI() {
        return this.jetty.getURI().resolve("/broker/");
    }

    private Handler createStaticResourceHandler() {
        ResourceHandler handler = new ResourceHandler();
        Resource res = Resource.newClassPathResource((String)"webapp");
        if (res == null) {
            throw new IllegalStateException("Resources folder 'webapp' not found.");
        }
        handler.setBaseResource(res);
        handler.setDirectoriesListed(true);
        handler.setWelcomeFiles(new String[]{"index.html"});
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/admin/html");
        context.insertHandler((HandlerWrapper)handler);
        return context;
    }

    public void start(InetSocketAddress addr) throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.jetty = new Server(addr);
        HandlerList handlers = new HandlerList();
        handlers.addHandler(this.createStaticResourceHandler());
        handlers.addHandler((Handler)context);
        this.jetty.setHandler((Handler)handlers);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.jetty.addBean((Object)errorHandler);
        ServletHolder jersey = new ServletHolder((Servlet)new ServletContainer(this.rc));
        context.addServlet(jersey, "/*");
        this.binder = new MyBinder(this.ds, this.config);
        this.rc.register((Object)this.binder);
        for (Object c : this.rc.getInstances()) {
            System.out.println("Instance:" + c.getClass() + ":" + c.toString());
        }
        this.jetty.start();
    }

    public void join() throws InterruptedException {
        this.jetty.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        System.out.println("Shutting down database..");
        try (Connection dbc = this.ds.getConnection();
             Statement st = dbc.createStatement();){
            st.executeUpdate("SHUTDOWN");
        }
        System.out.println("Cleanup jetty..");
        System.out.flush();
        this.jetty.destroy();
        this.binder.closeCloseables();
        HttpServer httpServer = this;
        synchronized (httpServer) {
            this.notifyAll();
        }
    }

    public void stop() throws Exception {
        this.jetty.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InetAddress bindaddr;
        int port;
        if (args.length == 0) {
            port = 8080;
            bindaddr = InetAddress.getLoopbackAddress();
        } else if (args.length == 1) {
            int colon = args[0].indexOf(58);
            if (colon == -1) {
                bindaddr = InetAddress.getLoopbackAddress();
                port = Integer.parseInt(args[0]);
            } else {
                bindaddr = InetAddress.getByName(args[0].substring(0, colon));
                port = Integer.parseInt(args[0].substring(colon + 1));
            }
        } else {
            System.err.println("Too many command line arguments!");
            System.err.println("Usage: " + HttpServer.class.getCanonicalName() + " [[hostname:]port]");
            System.exit(-1);
            return;
        }
        Class.forName("org.hsqldb.jdbcDriver");
        final HttpServer server = new HttpServer(new DefaultConfiguration());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    System.out.println("Executing shutdown hook..");
                    System.out.flush();
                    server.stop();
                    HttpServer httpServer = server;
                    synchronized (httpServer) {
                        server.wait(3000L);
                    }
                    System.out.println("Shutdown completed.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Failed to stop jetty during shutdown hook.");
                }
            }
        });
        try {
            server.start(new InetSocketAddress(bindaddr, port));
            System.err.println("Broker service at: " + server.getBrokerServiceURI());
            server.join();
        }
        finally {
            server.destroy();
        }
    }
}

