/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.aktin.broker.admin.auth.Token;

@Singleton
public class TokenManager {
    private static final Logger log = Logger.getLogger(TokenManager.class.getName());
    private Map<String, Token> map = new HashMap<String, Token>();
    private String simplePassword = System.getProperty("aktin.broker.password");

    public TokenManager() {
        if (this.simplePassword == null) {
            StringBuilder b = new StringBuilder(8);
            for (int i = 0; i < b.capacity(); ++i) {
                b.append(Character.valueOf((char)(48.0 + Math.random() * 74.0)));
            }
            this.simplePassword = b.toString();
        }
        System.err.println("Using password: " + this.simplePassword);
        log.info("Using password: " + this.simplePassword);
    }

    Token authenticate(String username, char[] charArray) {
        if (!this.simplePassword.equals(new String(charArray))) {
            return null;
        }
        Token t = new Token(username);
        this.map.put(t.getGUID(), t);
        return t;
    }

    public Token lookupToken(String guid) {
        return this.map.get(guid);
    }
}

