/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.aktin.broker.RequestTypeManager;
import org.aktin.broker.admin.auth.TokenManager;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.AggregatorImpl;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.BrokerImpl;
import org.aktin.broker.download.DownloadManager;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;

public class MyBinder
extends AbstractBinder {
    private static final Logger log = Logger.getLogger(MyBinder.class.getName());
    private DataSource ds;
    private Configuration config;
    private BrokerBackend broker;
    private AggregatorBackend aggregator;
    private DownloadManager downloads;
    private List<Closeable> closeables;

    public MyBinder(DataSource ds, Configuration config) {
        this.ds = ds;
        this.config = config;
        this.closeables = new LinkedList<Closeable>();
    }

    protected void configure() {
        try {
            this.broker = new BrokerImpl(this.ds, Paths.get(this.config.getBrokerDataPath(), new String[0]));
            this.aggregator = new AggregatorImpl(this.ds, Paths.get(this.config.getAggregatorDataPath(), new String[0]));
            this.downloads = new DownloadManager(Paths.get(this.config.getTempDownloadPath(), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bind(this.broker).to(BrokerBackend.class);
        this.bind(this.aggregator).to(AggregatorBackend.class);
        this.bind(new AuthCache(this.broker)).to(AuthCache.class);
        this.bind(new RequestTypeManager()).to(RequestTypeManager.class);
        this.bind(this.downloads).to(DownloadManager.class);
        this.bind(new TokenManager()).to(TokenManager.class);
    }

    public <T> ScopedBindingBuilder<T> bind(T service) {
        if (service instanceof Closeable) {
            this.closeables.add((Closeable)service);
        }
        return super.bind(service);
    }

    public void closeCloseables() {
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Exception during closing of " + c.getClass(), e);
            }
        }
    }
}

