/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.ws.rs.ext.Provider;
import org.aktin.broker.Authenticated;
import org.aktin.broker.auth.AuthFilterAPIKeys;

@Singleton
@Authenticated
@Provider
@Priority(value=1000)
public class PropertyFileAPIKeys
extends AuthFilterAPIKeys {
    private static final Logger log = Logger.getLogger(PropertyFileAPIKeys.class.getName());
    private Properties properties = new Properties();

    public PropertyFileAPIKeys(InputStream in) throws IOException {
        this.properties.load(in);
        log.info("Loaded " + this.properties.size() + " client API keys");
    }

    public String getClientDN(String apiKey) {
        return this.properties.getProperty(apiKey);
    }

    public Map<String, String> getMap() {
        return this.properties;
    }
}

