/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import liquibase.exception.LiquibaseException;
import org.aktin.broker.Broker;
import org.aktin.broker.admin.rest.FormTemplateEndpoint;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.admin.standalone.DefaultConfiguration;
import org.aktin.broker.admin.standalone.MyBinder;
import org.aktin.broker.db.LiquibaseWrapper;
import org.aktin.broker.server.auth.AuthProvider;
import org.aktin.broker.server.auth.HeaderAuthentication;
import org.aktin.broker.websocket.HeaderAuthSessionConfigurator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class HttpServer {
    private Configuration config;
    private ResourceConfig rc;
    private Server jetty;
    private DataSource ds;
    private MyBinder binder;
    private AuthProvider authFactory;
    private HeaderAuthentication auth;

    public HttpServer(Configuration config) throws SQLException, IOException {
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.JavaUtilLog");
        this.config = config;
        this.authFactory = config.getAuthProvider();
        Objects.requireNonNull(this.authFactory, "No AuthProvider available!");
        this.authFactory.setBasePath(config.getBasePath());
        this.auth = this.authFactory.getInstance();
        Objects.requireNonNull(this.auth);
        this.initialiseDatabase(config);
        this.rc = new ResourceConfig();
        this.rc.registerClasses(Broker.ENDPOINTS);
        this.rc.registerClasses(Broker.AUTH_FILTERS);
        this.rc.registerClasses(this.authFactory.getEndpoints());
        this.rc.register(FormTemplateEndpoint.class);
    }

    private void initialiseDatabase(Configuration config) throws SQLException {
        Class<? extends DataSource> clazz = null;
        try {
            clazz = config.getJdbcDataSourceClass();
            Objects.requireNonNull(clazz, "Unable resolve JDBC DataSource");
            this.ds = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method methodSetURL = clazz.getMethod("setURL", String.class);
            methodSetURL.invoke((Object)this.ds, config.getJdbcUrl());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SQLException("Unable to instantiate database DataSource class or missing/failed setURL(String) method for DataSource " + clazz.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Specified DataSource class not found in classpath");
        }
        try (LiquibaseWrapper w = new LiquibaseWrapper(this.ds.getConnection());){
            w.update();
        }
        catch (LiquibaseException e) {
            throw new SQLException("Unable to initialise database", e);
        }
    }

    protected void start_local(int port) throws Exception {
        this.start(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
    }

    public URI getBrokerServiceURI() {
        return this.jetty.getURI().resolve("/broker/");
    }

    private Handler createStaticResourceHandler() {
        ResourceHandler handler = new ResourceHandler();
        Resource res = Resource.newClassPathResource((String)"webapp");
        handler.setBaseResource(res);
        handler.setDirectoriesListed(true);
        handler.setWelcomeFiles(new String[]{"index.html"});
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/admin/html");
        context.insertHandler((HandlerWrapper)handler);
        return context;
    }

    public void start(InetSocketAddress addr) throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.jetty = new Server(addr);
        HandlerList handlers = new HandlerList();
        handlers.addHandler(this.createStaticResourceHandler());
        handlers.addHandler((Handler)context);
        this.jetty.setHandler((Handler)handlers);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.jetty.addBean((Object)errorHandler);
        ServletHolder jersey = new ServletHolder((Servlet)new ServletContainer(this.rc));
        context.addServlet(jersey, "/*");
        this.binder = new MyBinder(this.ds, this.config, this.authFactory, this.auth);
        this.rc.register((Object)this.binder);
        this.setupWebsockets(context);
        this.jetty.start();
    }

    private void setupWebsockets(ServletContextHandler context) throws Exception {
        ServerContainer c = WebSocketServerContainerInitializer.initialize((ServletContextHandler)context);
        c.setDefaultMaxSessionIdleTimeout(this.config.getWebsocketIdleTimeoutMillis());
        HeaderAuthSessionConfigurator sc = new HeaderAuthSessionConfigurator(this.auth, this.binder.getAuthCache());
        for (Class websocketClass : Broker.WEBSOCKETS) {
            String restPath = websocketClass.getAnnotation(ServerEndpoint.class).value();
            c.addEndpoint(ServerEndpointConfig.Builder.create((Class)websocketClass, (String)restPath).configurator((ServerEndpointConfig.Configurator)sc).build());
        }
    }

    public void join() throws InterruptedException {
        this.jetty.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        System.out.println("Shutting down database..");
        try (Connection dbc2 = this.ds.getConnection();
             Statement st = dbc2.createStatement();){
            st.executeUpdate("SHUTDOWN");
        }
        catch (SQLException dbc2) {
            // empty catch block
        }
        System.out.println("Cleanup jetty..");
        System.out.flush();
        try {
            this.jetty.destroy();
        }
        catch (Throwable e) {
            System.out.println("Jetty.destroy failed with " + e);
        }
        this.binder.closeCloseables();
        HttpServer httpServer = this;
        synchronized (httpServer) {
            this.notifyAll();
        }
    }

    public void stop() throws Exception {
        this.jetty.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InetAddress bindaddr;
        int port;
        if (args.length == 0) {
            port = 8080;
            bindaddr = InetAddress.getLoopbackAddress();
        } else if (args.length == 1) {
            int colon = args[0].indexOf(58);
            if (colon == -1) {
                bindaddr = InetAddress.getLoopbackAddress();
                port = Integer.parseInt(args[0]);
            } else {
                bindaddr = InetAddress.getByName(args[0].substring(0, colon));
                port = Integer.parseInt(args[0].substring(colon + 1));
            }
        } else {
            System.err.println("Too many command line arguments!");
            System.err.println("Usage: " + HttpServer.class.getCanonicalName() + " [[hostname:]port]");
            System.exit(-1);
            return;
        }
        Class.forName("org.hsqldb.jdbcDriver");
        final HttpServer server = new HttpServer(new DefaultConfiguration());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    System.out.println("Executing shutdown hook..");
                    System.out.flush();
                    server.stop();
                    HttpServer httpServer = server;
                    synchronized (httpServer) {
                        server.wait(3000L);
                    }
                    System.out.println("Shutdown completed.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Failed to stop jetty during shutdown hook.");
                }
            }
        });
        try {
            server.start(new InetSocketAddress(bindaddr, port));
            System.err.println("Broker service at: " + server.getBrokerServiceURI());
            server.join();
        }
        finally {
            server.destroy();
        }
    }
}

