/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.admin.standalone;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.aktin.broker.admin.standalone.Configuration;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.db.AggregatorBackend;
import org.aktin.broker.db.AggregatorImpl;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.BrokerImpl;
import org.aktin.broker.download.DownloadManager;
import org.aktin.broker.server.auth.AuthProvider;
import org.aktin.broker.server.auth.HeaderAuthentication;
import org.aktin.broker.util.RequestTypeManager;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;

public class MyBinder
extends AbstractBinder {
    private static final Logger log = Logger.getLogger(MyBinder.class.getName());
    private DataSource ds;
    private Configuration config;
    private BrokerBackend broker;
    private AggregatorBackend aggregator;
    private DownloadManager downloads;
    private AuthProvider authProvider;
    private HeaderAuthentication auth;
    private AuthCache authCache;
    private List<Closeable> closeables;

    public MyBinder(DataSource ds, Configuration config, AuthProvider authProvider, HeaderAuthentication auth) throws IOException {
        this.ds = ds;
        this.authProvider = authProvider;
        this.auth = auth;
        this.config = config;
        this.closeables = new LinkedList<Closeable>();
        this.broker = new BrokerImpl(ds, Paths.get(config.getBrokerDataPath(), new String[0]));
        this.authCache = new AuthCache(this.broker);
    }

    protected void configure() {
        try {
            this.aggregator = new AggregatorImpl(this.ds, Paths.get(this.config.getAggregatorDataPath(), new String[0]));
            this.downloads = new DownloadManager(Paths.get(this.config.getTempDownloadPath(), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bind(this.broker).to(BrokerBackend.class);
        this.bind(this.aggregator).to(AggregatorBackend.class);
        this.bind(this.authCache).to(AuthCache.class);
        this.bind(new RequestTypeManager()).to(RequestTypeManager.class);
        this.bind(this.downloads).to(DownloadManager.class);
        this.bind(this.auth).to(HeaderAuthentication.class);
        this.authProvider.bindSingletons((o, c) -> this.bind(o).to(c));
    }

    public <T> ScopedBindingBuilder<T> bind(T service) {
        if (service instanceof Closeable) {
            this.closeables.add((Closeable)service);
        }
        return super.bind(service);
    }

    public void closeCloseables() {
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Exception during closing of " + String.valueOf(c.getClass()), e);
            }
        }
    }

    public AuthCache getAuthCache() {
        return this.authCache;
    }
}

