/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.Variant;
import org.aktin.broker.Authenticated;
import org.aktin.broker.DigestPathDataSource;
import org.aktin.broker.RequestConverter;
import org.aktin.broker.RequestTypeManager;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.notify.BrokerWebsocket;
import org.aktin.broker.server.DateDataSource;
import org.aktin.broker.xml.BrokerStatus;
import org.aktin.broker.xml.Node;
import org.aktin.broker.xml.NodeList;
import org.aktin.broker.xml.RequestInfo;
import org.aktin.broker.xml.RequestList;
import org.aktin.broker.xml.RequestStatus;
import org.aktin.broker.xml.RequestStatusList;
import org.aktin.broker.xml.RequestTargetNodes;

@Path(value="/broker/")
public class BrokerEndpoint {
    private static final Logger log = Logger.getLogger(BrokerEndpoint.class.getName());
    public static final String SERVICE_URL = "/broker/";
    @Inject
    private BrokerBackend db;
    @Inject
    private AuthCache auth;
    @Inject
    RequestTypeManager typeManager;

    @GET
    @Path(value="status")
    @Produces(value={"application/xml"})
    public BrokerStatus status() {
        return BrokerStatus.create();
    }

    @GET
    @Path(value="node")
    @Produces(value={"application/xml"})
    public Response allNodes() {
        try {
            List nodes = this.db.getAllNodes();
            this.auth.fillCachedAccessTimestamps(nodes);
            return Response.ok((Object)new NodeList(nodes)).build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "unable to retrieve node list", e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="node/{id}")
    @Produces(value={"application/xml"})
    public Node getNodeInfo(@PathParam(value="id") int nodeId) {
        Node node;
        try {
            node = this.db.getNode(nodeId);
            if (node == null) {
                throw new NotFoundException();
            }
            this.auth.fillCachedAccessTimestamps(Collections.singletonList(node));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "unable to retrieve node list", e);
            throw new InternalServerErrorException((Throwable)e);
        }
        return node;
    }

    @GET
    @Path(value="node/{node}/{resource}")
    public Response getNodeResource(@PathParam(value="node") int nodeId, @PathParam(value="resource") String resourceId) throws SQLException {
        DateDataSource ds = this.db.getNodeResource(nodeId, resourceId);
        if (ds == null) {
            throw new NotFoundException();
        }
        Response.ResponseBuilder resp = Response.ok((Object)ds, (String)ds.getContentType());
        if (ds instanceof DigestPathDataSource) {
            resp.tag(Base64.getUrlEncoder().encodeToString(((DigestPathDataSource)ds).sha256));
            resp.header("Content-MD5", (Object)Base64.getUrlEncoder().encodeToString(((DigestPathDataSource)ds).md5));
        }
        resp.lastModified(Date.from(ds.getLastModified()));
        return resp.build();
    }

    @Authenticated
    @PUT
    @Path(value="my/node/{resource}")
    public void setNodesResource(@PathParam(value="resource") String resourceId, @Context HttpHeaders headers, @Context SecurityContext sec, InputStream content) {
        Principal user = (Principal)sec.getUserPrincipal();
        log.info("Resource uploaded by node " + user.getNodeId() + ": " + resourceId);
        try {
            this.db.updateNodeResource(user.getNodeId(), resourceId, headers.getMediaType(), content);
        }
        catch (IOException | SQLException e) {
            log.log(Level.SEVERE, "Unable to write resource for node " + user.getNodeId() + ": " + resourceId, e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @Authenticated
    @GET
    @Path(value="my/node")
    @Produces(value={"application/xml"})
    public Node getOwnNodeInfo(@Context SecurityContext sec) {
        Principal user = (Principal)sec.getUserPrincipal();
        try {
            return this.db.getNode(user.getNodeId());
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to read node info for nodeId=" + user.getNodeId(), e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @Authenticated
    @GET
    @Path(value="my/request")
    @Produces(value={"application/xml"})
    public RequestList listNodesRequests(@Context SecurityContext sec) {
        Principal user = (Principal)sec.getUserPrincipal();
        try {
            return new RequestList(this.db.listRequestsForNode(user.getNodeId()));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to read requests for nodeId=" + user.getNodeId(), e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @Authenticated
    @GET
    @Path(value="my/request/{id}")
    public Response getNodesRequest(@PathParam(value="id") Integer requestId, @Context SecurityContext sec, @Context HttpHeaders headers) throws SQLException, IOException {
        Principal user = (Principal)sec.getUserPrincipal();
        Response resp = this.getRequest(requestId, headers);
        if (resp.getStatus() == 200) {
            this.db.setRequestNodeStatus(requestId, user.getNodeId(), RequestStatus.retrieved, Instant.now());
        }
        return resp;
    }

    @Authenticated
    @POST
    @Path(value="my/request/{id}/status/{status}")
    public Response putNodesRequestError(@PathParam(value="id") Integer requestId, @PathParam(value="status") RequestStatus status, @Context SecurityContext sec, @Context HttpHeaders headers, Reader content) {
        Principal user = (Principal)sec.getUserPrincipal();
        Date date = headers.getDate();
        if (date == null) {
            date = new Date();
        }
        try {
            this.db.setRequestNodeStatus(requestId, user.getNodeId(), status, date.toInstant());
            if (headers.getMediaType() != null) {
                MediaType messageType = BrokerEndpoint.removeCharsetInfo(headers.getMediaType());
                this.db.setRequestNodeStatusMessage(requestId, user.getNodeId(), messageType.toString(), content);
            }
            content.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to update status for requestId=" + requestId + " for nodeId=" + user.getNodeId(), e);
            return Response.serverError().build();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to close content reader", e);
        }
        BrokerWebsocket.broadcastRequestNodeStatus(requestId, user.getNodeId(), status.name());
        return Response.noContent().build();
    }

    @Authenticated
    @DELETE
    @Path(value="my/request/{id}")
    public Response deleteNodesRequest(@PathParam(value="id") String requestId, @Context SecurityContext sec) {
        Principal user = (Principal)sec.getUserPrincipal();
        boolean delete_ok = false;
        try {
            delete_ok = this.db.markRequestDeletedForNode(user.getNodeId(), Integer.parseInt(requestId));
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, "Unable to parse request id=" + requestId, e);
            delete_ok = false;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to delete requestId=" + requestId + " for nodeId=" + user.getNodeId(), e);
            return Response.serverError().build();
        }
        if (delete_ok) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private static MediaType removeCharsetInfo(MediaType type) {
        return new MediaType(type.getType(), type.getSubtype());
    }

    @POST
    @Path(value="request")
    public Response createRequest(Reader content, @Context HttpHeaders headers) throws URISyntaxException {
        MediaType type = headers.getMediaType();
        try {
            type = BrokerEndpoint.removeCharsetInfo(type);
            int id = this.db.createRequest(type.toString(), content);
            return Response.created((URI)new URI("/broker/request/" + Integer.toString(id))).build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to create request", e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="request/{id}")
    public Response createRequest(@PathParam(value="id") String requestId, Reader content, @Context HttpHeaders headers) throws URISyntaxException {
        MediaType type = headers.getMediaType();
        try {
            type = BrokerEndpoint.removeCharsetInfo(type);
            this.db.setRequestDefinition(Integer.parseInt(requestId), type.toString(), content);
            return Response.ok().build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to create request definition", e);
            return Response.serverError().build();
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "Unable to parse request id: " + requestId, e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="request")
    @Produces(value={"application/xml"})
    public Response listAllRequests() {
        try {
            return Response.ok((Object)new RequestList(this.db.listAllRequests())).build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to read requests", e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="request/{id}")
    public Response deleteRequest(@PathParam(value="id") String id) {
        int i;
        try {
            i = Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            log.warning("Unable to delete non-numeric request id: " + id);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.db.deleteRequest(i);
            return Response.noContent().build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to delete request " + id, e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="request/{id}")
    public Response getRequest(@PathParam(value="id") Integer requestId, @Context HttpHeaders headers) throws SQLException, IOException, NotFoundException {
        List accept = headers.getAcceptableMediaTypes();
        MediaType[] available = this.typeManager.createMediaTypes(this.db.getRequestTypes(requestId));
        if (available.length == 0) {
            throw new NotFoundException();
        }
        RequestConverter rc = this.typeManager.buildConverterChain(accept, Arrays.asList(available));
        if (rc == null) {
            return Response.notAcceptable((List)Variant.mediaTypes((MediaType[])available).build()).build();
        }
        Reader def = this.db.getRequestDefinition(requestId, rc.getConsumedType());
        def = rc.transform(def);
        return Response.ok((Object)def, (MediaType)MediaType.valueOf((String)rc.getProducedType())).build();
    }

    @OPTIONS
    @Path(value="request/{id}")
    public Response getRequestInfo(@PathParam(value="id") int requestId, @Context HttpHeaders headers) throws SQLException, IOException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        Response.ResponseBuilder response = info == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok((Object)info, (MediaType)MediaType.APPLICATION_XML_TYPE);
        return response.allow(new String[]{"GET", "PUT", "DELETE", "OPTIONS"}).build();
    }

    @GET
    @Path(value="request/{id}/status")
    @Produces(value={"application/xml"})
    public RequestStatusList getRequestInfo(@PathParam(value="id") Integer requestId) throws SQLException, IOException {
        List list = this.db.listRequestNodeStatus(requestId);
        if (list == null) {
            throw new NotFoundException();
        }
        return new RequestStatusList(list);
    }

    @GET
    @Path(value="request/{id}/nodes")
    @Produces(value={"application/xml"})
    public RequestTargetNodes getRequestTargetNodes(@PathParam(value="id") Integer requestId) throws SQLException, IOException, NotFoundException {
        int[] nodes = this.db.getRequestTargets(requestId);
        if (nodes == null) {
            throw new NotFoundException();
        }
        return new RequestTargetNodes(nodes);
    }

    @DELETE
    @Path(value="request/{id}/nodes")
    public void clearRequestTargetNodes(@PathParam(value="id") Integer requestId) throws SQLException, IOException, NotFoundException {
        this.db.clearRequestTargets(requestId);
    }

    @PUT
    @Path(value="request/{id}/nodes")
    @Consumes(value={"application/xml"})
    public void setRequestTargetNodes(@PathParam(value="id") Integer requestId, RequestTargetNodes nodes) throws SQLException, IOException, NotFoundException {
        this.db.setRequestTargets(requestId, nodes.getNodes());
    }

    @GET
    @Path(value="request/{id}/status/{nodeId}")
    public Response getRequestNodeStatusMessage(@PathParam(value="id") Integer requestId, @PathParam(value="nodeId") Integer nodeId) throws SQLException, IOException {
        Reader r = this.db.getRequestNodeStatusMessage(requestId, nodeId);
        if (r == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)r, (String)"text/plain").build();
    }

    @POST
    @Path(value="request/{id}/publish")
    public void publishRequest(@PathParam(value="id") Integer requestId) throws SQLException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        if (info == null) {
            throw new NotFoundException();
        }
        if (info.published == null) {
            this.db.setRequestPublished(requestId, Instant.now());
            BrokerWebsocket.broadcastRequestPublished(requestId);
        }
    }

    @POST
    @Path(value="request/{id}/close")
    public void closeRequest(@PathParam(value="id") Integer requestId) throws SQLException {
        RequestInfo info = this.db.getRequestInfo(requestId);
        if (info == null) {
            throw new NotFoundException();
        }
        if (info.closed == null) {
            this.db.setRequestClosed(requestId, Instant.now());
            BrokerWebsocket.broadcastRequestClosed(requestId);
        }
    }
}

