/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.auth.Principal;

public abstract class AuthFilterAPIKeys
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(AuthFilterAPIKeys.class.getName());
    @Inject
    private AuthCache authCache;

    public abstract String getClientDN(String var1);

    public final void filter(ContainerRequestContext ctx) throws IOException {
        String auth = ctx.getHeaderString("Authorization");
        String key = null;
        if (auth != null && auth.startsWith("Bearer ")) {
            key = auth.substring(7);
        }
        if (key == null) {
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            log.info("HTTP Authorization header missing");
            return;
        }
        String clientDn = this.getClientDN(key);
        if (clientDn == null) {
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            log.info("Access denied for API key: " + key);
        }
        try {
            Principal principal = this.authCache.getPrincipal(key, clientDn);
            ctx.setSecurityContext((SecurityContext)principal);
            log.info("Principal found: " + principal.getName());
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to lookup principal", e);
            ctx.abortWith(Response.serverError().build());
        }
    }
}

