/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.auth.AuthFilterAPIKeys;
import org.aktin.broker.auth.Principal;

@RequireAdmin
@Provider
@Priority(value=2000)
public class AuthFilterAdmin
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(AuthFilterAPIKeys.class.getName());

    public void filter(ContainerRequestContext ctx) throws IOException {
        SecurityContext sc = ctx.getSecurityContext();
        if (sc == null) {
            log.info("no security context");
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return;
        }
        java.security.Principal p = sc.getUserPrincipal();
        if (p == null || !(p instanceof Principal)) {
            log.info("no principal or wrong instance: " + p);
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return;
        }
        if (!((Principal)p).isAdmin()) {
            log.info("no admin: " + p);
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return;
        }
    }
}

