/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.db;

import java.sql.Connection;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.aktin.broker.db.ClassResourceAccessor;

public class LiquibaseWrapper
implements AutoCloseable {
    private Database database;
    private Liquibase liquibase;
    public static final String CHANGELOG_RESOURCE = "/database.xml";

    public LiquibaseWrapper(Connection connection) throws LiquibaseException {
        this.database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        ClassResourceAccessor ra = new ClassResourceAccessor(LiquibaseWrapper.class);
        this.liquibase = new Liquibase(CHANGELOG_RESOURCE, (ResourceAccessor)ra, this.database);
    }

    public void update() throws LiquibaseException {
        this.liquibase.update(new Contexts(), new LabelExpression());
    }

    public void reset() throws LiquibaseException {
        this.liquibase.dropAll();
        this.update();
    }

    @Override
    public void close() throws DatabaseException {
        if (this.database.getConnection().isClosed()) {
            throw new DatabaseException("Connection closed");
        }
    }
}

