/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.sql.SQLException;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.aktin.broker.DigestPathDataSource;
import org.aktin.broker.RequireAdmin;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.server.DateDataSource;
import org.aktin.broker.xml.Node;
import org.aktin.broker.xml.NodeList;

@Path(value="/broker/node/")
public class NodeInfoEndpoint {
    private static final Logger log = Logger.getLogger(NodeInfoEndpoint.class.getName());
    @Inject
    private BrokerBackend db;
    @Inject
    private AuthCache auth;

    @GET
    @Produces(value={"application/xml"})
    @RequireAdmin
    public Response allNodes() {
        try {
            List nodes = this.db.getAllNodes();
            this.auth.fillCachedAccessTimestamps(nodes);
            return Response.ok((Object)new NodeList(nodes)).build();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "unable to retrieve node list", e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml"})
    @RequireAdmin
    public Node getNodeInfo(@PathParam(value="id") int nodeId) {
        Node node;
        try {
            node = this.db.getNode(nodeId);
            if (node == null) {
                throw new NotFoundException();
            }
            this.auth.fillCachedAccessTimestamps(Collections.singletonList(node));
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "unable to retrieve node list", e);
            throw new InternalServerErrorException((Throwable)e);
        }
        return node;
    }

    @GET
    @Path(value="{node}/{resource}")
    @RequireAdmin
    public Response getNodeResource(@PathParam(value="node") int nodeId, @PathParam(value="resource") String resourceId) throws SQLException {
        DateDataSource ds = this.db.getNodeResource(nodeId, resourceId);
        if (ds == null) {
            throw new NotFoundException();
        }
        Response.ResponseBuilder resp = Response.ok((Object)ds, (String)ds.getContentType());
        if (ds instanceof DigestPathDataSource) {
            resp.tag(Base64.getUrlEncoder().encodeToString(((DigestPathDataSource)ds).sha256));
            resp.header("Content-MD5", (Object)Base64.getUrlEncoder().encodeToString(((DigestPathDataSource)ds).md5));
        }
        resp.lastModified(Date.from(ds.getLastModified()));
        return resp.build();
    }
}

