/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import org.aktin.broker.server.DateDataSource;

public class PathDataSource
implements DateDataSource {
    private Path path;
    private String type;
    private Instant lastModified;

    public PathDataSource(Path path, String type, Instant lastModified) {
        this.path = path;
        this.type = type;
        this.lastModified = lastModified;
    }

    public String getContentType() {
        return this.type;
    }

    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    public Instant getLastModified() {
        return this.lastModified;
    }
}

