/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.aktin.broker.auth.AuthCache;
import org.aktin.broker.auth.Principal;

public class AuthFilterSSLHeaders
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(AuthFilterSSLHeaders.class.getName());
    public static final String X_SSL_CLIENT_ID = "X-SSL-Client-ID";
    public static final String X_SSL_CLIENT_DN = "X-SSL-Client-DN";
    public static final String X_SSL_CLIENT_VERIFY = "X-SSL-Client-Verify";
    @Inject
    private AuthCache authCache;

    public void filter(ContainerRequestContext ctx) throws IOException {
        String verify = ctx.getHeaderString(X_SSL_CLIENT_VERIFY);
        String id = ctx.getHeaderString(X_SSL_CLIENT_ID);
        String dn = ctx.getHeaderString(X_SSL_CLIENT_DN);
        if (verify == null || !verify.equals("SUCCESS")) {
            ctx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            log.info("Client verify header not found or not successful");
            return;
        }
        try {
            Principal principal = this.authCache.getPrincipal(id, dn);
            ctx.setSecurityContext((SecurityContext)principal);
            log.info("Principal found: " + principal.getName());
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Unable to lookup principal", e);
            ctx.abortWith(Response.serverError().build());
        }
    }
}

