/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.auth;

import javax.ws.rs.core.SecurityContext;

public class Principal
implements java.security.Principal,
SecurityContext {
    private int nodeId;
    private String commonName;
    private String clientDn;
    private long lastAccessed;

    public Principal(int nodeId, String clientDn) {
        this.nodeId = nodeId;
        this.clientDn = clientDn;
        if (clientDn != null && clientDn.startsWith("CN=")) {
            int e = clientDn.indexOf(44);
            if (e == -1) {
                e = clientDn.length();
            }
            this.commonName = clientDn.substring(3, e);
        }
    }

    public String getClientDN() {
        return this.clientDn;
    }

    @Override
    public String getName() {
        if (this.commonName != null) {
            return this.commonName;
        }
        return Integer.toString(this.getNodeId());
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public java.security.Principal getUserPrincipal() {
        return this;
    }

    public boolean isUserInRole(String role) {
        return role.equals("admini");
    }

    public boolean isSecure() {
        return true;
    }

    public String getAuthenticationScheme() {
        return "CLIENT_CERT";
    }

    public boolean isAdmin() {
        return Principal.isAdminDN(this.clientDn);
    }

    public static final boolean isAdminDN(String clientDn) {
        return clientDn != null && clientDn.contains("OU=admin");
    }

    public void updateLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }
}

