/*
 * Decompiled with CFR 0.152.
 */
package org.aktin.broker.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.core.MediaType;
import org.aktin.broker.DigestPathDataSource;
import org.aktin.broker.auth.Principal;
import org.aktin.broker.db.BrokerBackend;
import org.aktin.broker.db.DigestCalculatingInputStream;
import org.aktin.broker.server.Broker;
import org.aktin.broker.xml.Node;
import org.aktin.broker.xml.RequestInfo;
import org.aktin.broker.xml.RequestStatus;
import org.aktin.broker.xml.RequestStatusInfo;
import org.aktin.broker.xml.util.Util;

@Singleton
public class BrokerImpl
implements BrokerBackend,
Broker {
    private static final Logger log = Logger.getLogger(BrokerImpl.class.getName());
    private static final String[] RESOURCE_DIGESTS = new String[]{"MD5", "SHA-256"};
    private DataSource brokerDB;
    private Path dataDir;
    private int inMemoryTreshold = 65536;
    private static final String SELECT_MEDIATYPE_BY_REQUESTID = "SELECT media_type FROM request_definitions WHERE request_id=?";

    public BrokerImpl() {
    }

    public BrokerImpl(DataSource brokerDB, Path dataDirectory) throws IOException {
        this();
        this.setBrokerDB(brokerDB);
        this.setDataDirectory(dataDirectory);
        Files.createDirectories(dataDirectory, new FileAttribute[0]);
    }

    @Override
    @Resource(name="brokerDB")
    public void setBrokerDB(DataSource brokerDB) {
        this.brokerDB = brokerDB;
    }

    public void setDataDirectory(Path dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public void clearDataDirectory() throws IOException {
        try (Stream<Path> files = Files.list(this.dataDir);){
            files.forEach(t -> {
                try {
                    Files.delete(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public List<Node> getAllNodes() throws SQLException {
        ArrayList<Node> nl = new ArrayList<Node>();
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement st = dbc.prepareStatement("SELECT id, subject_dn, last_contact FROM nodes");
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                if (Principal.isAdminDN(rs.getString(2))) continue;
                nl.add(new Node(rs.getInt(1), rs.getString(2), rs.getTimestamp(3).toInstant()));
            }
            rs.close();
            st.close();
        }
        return nl;
    }

    public Node getNode(int nodeId) throws SQLException {
        Node n;
        try (Connection dbc = this.brokerDB.getConnection();){
            Statement st = dbc.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, subject_dn, last_contact FROM nodes WHERE id=" + nodeId);
            n = rs.next() ? new Node(rs.getInt(1), rs.getString(2), rs.getTimestamp(3).toInstant()) : null;
            rs.close();
            st.close();
            if (n != null) {
                st = dbc.createStatement();
                rs = st.executeQuery("SELECT module, version FROM node_modules WHERE node_id=" + nodeId);
                n.modules = new HashMap();
                while (rs.next()) {
                    n.modules.put(rs.getString(1), rs.getString(2));
                }
                rs.close();
                st.close();
            }
        }
        return n;
    }

    protected int getLastInsertId(Connection dbc) throws SQLException {
        try (Statement st = dbc.createStatement();
             ResultSet rs = st.executeQuery("CALL IDENTITY()");){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        throw new SQLException("Unable get last insert id");
    }

    private int createEmptyRequest(Connection dbc) throws SQLException {
        Statement st = dbc.createStatement();
        st.executeUpdate("INSERT INTO requests(created) VALUES(NOW())");
        st.close();
        return this.getLastInsertId(dbc);
    }

    public int createRequest(String mediaType, Reader content) throws SQLException {
        int id;
        try (Connection dbc = this.brokerDB.getConnection();){
            id = this.createEmptyRequest(dbc);
            this.setRequestDefinition(dbc, id, mediaType, content);
            dbc.commit();
        }
        return id;
    }

    public int createRequest() throws SQLException {
        int id;
        try (Connection dbc = this.brokerDB.getConnection();){
            id = this.createEmptyRequest(dbc);
            dbc.commit();
        }
        return id;
    }

    private void setRequestDefinition(Connection dbc, int requestId, String mediaType, Reader content) throws SQLException {
        PreparedStatement ps = dbc.prepareStatement("SELECT COUNT(*) FROM request_definitions WHERE request_id=? AND media_type=?");
        ps.setInt(1, requestId);
        ps.setString(2, mediaType);
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean hasRecord = rs.getInt(1) != 0;
        rs.close();
        ps.close();
        ps = null;
        if (hasRecord) {
            ps = dbc.prepareStatement("UPDATE request_definitions SET query_def=? WHERE request_id=? AND media_type=?");
            ps.setClob(1, content);
            ps.setInt(2, requestId);
            ps.setString(3, mediaType);
            ps.executeUpdate();
            ps.close();
            log.info("Updated definition for request " + requestId + ": " + mediaType);
        } else {
            ps = dbc.prepareStatement("INSERT INTO request_definitions (request_id, media_type, query_def) VALUES(?,?,?)");
            ps.setInt(1, requestId);
            ps.setString(2, mediaType);
            ps.setClob(3, content);
            ps.executeUpdate();
            ps.close();
            log.info("New definition for request " + requestId + ": " + mediaType);
        }
    }

    public void setRequestDefinition(int requestId, String mediaType, Reader content) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            this.setRequestDefinition(dbc, requestId, mediaType, content);
            dbc.commit();
        }
    }

    public void deleteRequest(int id) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("DELETE FROM request_definitions WHERE request_id=?");
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            ps = dbc.prepareStatement("DELETE FROM requests WHERE id=?");
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            dbc.commit();
        }
        log.info("Request " + id + " deleted");
    }

    private List<RequestInfo> loadRequestList(ResultSet rs, int mediaTypeIndex, RequestInfoLoader loader) throws SQLException {
        ArrayList<RequestInfo> l = new ArrayList<RequestInfo>();
        ArrayList<String> types = new ArrayList<String>();
        int prevId = -1;
        RequestInfo req = null;
        while (rs.next()) {
            int id = rs.getInt(1);
            if (id != prevId) {
                if (req != null) {
                    req.setTypes(types.toArray(new String[types.size()]));
                    l.add(req);
                    types.clear();
                }
                req = loader.load(rs);
                types.add(rs.getString(mediaTypeIndex));
            } else {
                types.add(rs.getString(mediaTypeIndex));
            }
            prevId = id;
        }
        if (req != null) {
            req.setTypes(types.toArray(new String[types.size()]));
            l.add(req);
        }
        return l;
    }

    public List<RequestInfo> listAllRequests() throws SQLException {
        List<RequestInfo> list;
        try (Connection dbc = this.brokerDB.getConnection();){
            Statement st = dbc.createStatement();
            ResultSet rs = st.executeQuery("SELECT r.id, r.published, r.closed, d.media_type, r.targeted FROM requests r JOIN request_definitions d ON r.id=d.request_id ORDER BY r.id");
            list = this.loadRequestList(rs, 4, r -> new RequestInfo(r.getInt(1), this.optionalTimestamp(rs, 2), this.optionalTimestamp(rs, 3), rs.getBoolean(5)));
            rs.close();
            st.close();
        }
        return list;
    }

    private Instant optionalTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp ts = rs.getTimestamp(index);
        return ts == null ? null : ts.toInstant();
    }

    public List<String> getRequestTypes(int requestId) throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement(SELECT_MEDIATYPE_BY_REQUESTID);
            ps.setInt(1, requestId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                types.add(rs.getString(1));
            }
        }
        return types;
    }

    private Reader createTemporaryClobReader(Clob clob) throws SQLException, IOException {
        if (clob.length() < (long)this.inMemoryTreshold) {
            String str = null;
            try (Reader reader = clob.getCharacterStream();){
                str = Util.readContent((Reader)reader);
            }
            return new StringReader(str);
        }
        throw new UnsupportedOperationException("Temporary file CLOB reader not implemented yet. Size > " + this.inMemoryTreshold);
    }

    public Reader getRequestDefinition(int requestId, String mediaType) throws SQLException, IOException {
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("SELECT query_def FROM request_definitions WHERE request_id=? AND media_type=?");
            ps.setInt(1, requestId);
            ps.setString(2, mediaType);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                Reader reader = null;
                return reader;
            }
            Reader reader = this.createTemporaryClobReader(rs.getClob(1));
            return reader;
        }
    }

    public List<RequestInfo> listRequestsForNode(int nodeId) throws SQLException {
        ArrayList<RequestInfo> list = new ArrayList<RequestInfo>();
        ArrayList<String> types = new ArrayList<String>();
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement(SELECT_MEDIATYPE_BY_REQUESTID);
            Statement st = dbc.createStatement();
            ResultSet rs = st.executeQuery("SELECT r.id, r.published, r.closed, r.targeted, s.retrieved, s.interaction, s.queued, s.processing, s.completed, s.rejected, s.failed FROM requests r LEFT OUTER JOIN request_node_status s ON r.id=s.request_id AND s.node_id=" + nodeId + " WHERE s.deleted IS NULL AND r.closed IS NULL AND r.published IS NOT NULL AND (r.targeted = FALSE OR s.request_id IS NOT NULL) ORDER BY r.id");
            while (rs.next()) {
                RequestInfo ri = new RequestInfo(rs.getInt(1), this.optionalTimestamp(rs, 2), this.optionalTimestamp(rs, 3), rs.getBoolean(4));
                RequestStatusInfo status = new RequestStatusInfo();
                status.retrieved = this.optionalTimestamp(rs, 5);
                status.interaction = this.optionalTimestamp(rs, 6);
                status.queued = this.optionalTimestamp(rs, 7);
                status.processing = this.optionalTimestamp(rs, 8);
                status.completed = this.optionalTimestamp(rs, 9);
                status.rejected = this.optionalTimestamp(rs, 10);
                status.failed = this.optionalTimestamp(rs, 11);
                ri.nodeStatus = status.getStatus() == null ? Collections.emptyList() : Collections.singletonList(status);
                list.add(ri);
                ps.setInt(1, rs.getInt(1));
                ps.clearWarnings();
                types.clear();
                ResultSet rs2 = ps.executeQuery();
                while (rs2.next()) {
                    types.add(rs2.getString(1));
                }
                if (types.isEmpty()) continue;
                ri.setTypes(types.toArray(new String[types.size()]));
            }
            rs.close();
            st.close();
        }
        return list;
    }

    public RequestInfo getRequestInfo(int requestId) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            RequestInfo requestInfo = this.loadRequest(dbc, requestId, true);
            return requestInfo;
        }
    }

    private RequestInfo loadRequest(Connection dbc, int requestId, boolean fillTypes) throws SQLException {
        Statement st = dbc.createStatement();
        ResultSet rs = st.executeQuery("SELECT r.id, r.published, r.closed, r.targeted FROM requests r WHERE r.id=" + requestId);
        RequestInfo ri = null;
        if (rs.next()) {
            ri = new RequestInfo(rs.getInt(1), this.optionalTimestamp(rs, 2), this.optionalTimestamp(rs, 3), rs.getBoolean(4));
        }
        rs.close();
        st.close();
        if (fillTypes) {
            PreparedStatement ps = dbc.prepareStatement(SELECT_MEDIATYPE_BY_REQUESTID);
            ps.setInt(1, requestId);
            ArrayList<String> types = new ArrayList<String>();
            rs = ps.executeQuery();
            while (rs.next()) {
                types.add(rs.getString(1));
            }
            if (!types.isEmpty()) {
                ri.setTypes(types.toArray(new String[types.size()]));
            }
        }
        return ri;
    }

    private boolean loadRequestNodeStatus(Connection dbc, int nodeId, int requestId, RequestStatusInfo ri) throws SQLException {
        Statement st = dbc.createStatement();
        ResultSet rs = st.executeQuery("SELECT retrieved, deleted FROM request_node_status r WHERE request_id=" + requestId + " AND node_id=" + nodeId);
        boolean status_found = false;
        if (rs.next()) {
            status_found = true;
            ri.retrieved = this.optionalTimestamp(rs, 1);
            ri.deleted = this.optionalTimestamp(rs, 2);
        }
        rs.close();
        st.close();
        return status_found;
    }

    public void setRequestNodeStatus(int requestId, int nodeId, RequestStatus status, Instant timestamp) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            Timestamp ts = Timestamp.from(timestamp);
            int rowCount = 0;
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE request_node_status SET ").append(status.name()).append("=?");
            if (status != RequestStatus.interaction) {
                sql.append(", interaction=NULL");
            }
            sql.append(" WHERE request_id=? AND node_id=?");
            PreparedStatement ps = dbc.prepareStatement(sql.toString());
            ps.setTimestamp(1, ts);
            ps.setInt(2, requestId);
            ps.setInt(3, nodeId);
            rowCount = ps.executeUpdate();
            ps.close();
            if (rowCount == 0) {
                ps = dbc.prepareStatement("INSERT INTO request_node_status(request_id, node_id, " + status.name() + ") VALUES(?,?,?)");
                ps.setInt(1, requestId);
                ps.setInt(2, nodeId);
                ps.setTimestamp(3, ts);
                ps.executeUpdate();
                ps.close();
            }
            dbc.commit();
        }
    }

    public void setRequestNodeStatusMessage(int requestId, int nodeId, String mediaType, Reader message) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("UPDATE request_node_status SET message_type=?, message=? WHERE request_id=? AND node_id=?");
            ps.setString(1, mediaType);
            ps.setClob(2, message);
            ps.setInt(3, requestId);
            ps.setInt(4, nodeId);
            ps.executeUpdate();
            ps.close();
            dbc.commit();
        }
    }

    public Reader getRequestNodeStatusMessage(int requestId, int nodeId) throws SQLException, IOException {
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("SELECT message_type, message FROM request_node_status WHERE request_id=? AND node_id=?");
            ps.setInt(1, requestId);
            ps.setInt(2, nodeId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                Reader reader = null;
                return reader;
            }
            Clob clob = rs.getClob(2);
            if (clob == null) {
                Reader reader = null;
                return reader;
            }
            Reader reader = this.createTemporaryClobReader(clob);
            return reader;
        }
    }

    public boolean markRequestDeletedForNode(int nodeId, int requestId) throws SQLException {
        boolean delete_ok = false;
        try (Connection dbc = this.brokerDB.getConnection();){
            RequestStatusInfo si = new RequestStatusInfo();
            RequestInfo ri = this.loadRequest(dbc, requestId, false);
            if (ri == null) {
            } else if (!this.loadRequestNodeStatus(dbc, nodeId, requestId, si)) {
                Statement st = dbc.createStatement();
                st.executeUpdate("INSERT INTO request_node_status(deleted, node_id, request_id) VALUES(NOW()," + nodeId + "," + requestId + ")");
                st.close();
                dbc.commit();
                delete_ok = true;
            } else if (si.deleted == null) {
                Statement st = dbc.createStatement();
                st.executeUpdate("UPDATE request_node_status SET deleted=NOW() WHERE request_id=" + requestId + " AND node_id=" + nodeId);
                st.close();
                dbc.commit();
                delete_ok = true;
            }
        }
        return delete_ok;
    }

    public List<RequestStatusInfo> listRequestNodeStatus(Integer requestId) throws SQLException {
        ArrayList<RequestStatusInfo> list = new ArrayList<RequestStatusInfo>();
        try (Connection dbc = this.brokerDB.getConnection();){
            Statement st = dbc.createStatement();
            ResultSet rs = st.executeQuery("SELECT node_id, retrieved, deleted, queued, processing, completed, rejected, failed, interaction, message_type  FROM request_node_status WHERE request_id=" + requestId);
            while (rs.next()) {
                RequestStatusInfo info = new RequestStatusInfo(rs.getInt(1));
                info.retrieved = this.optionalTimestamp(rs, 2);
                info.deleted = this.optionalTimestamp(rs, 3);
                info.queued = this.optionalTimestamp(rs, 4);
                info.processing = this.optionalTimestamp(rs, 5);
                info.completed = this.optionalTimestamp(rs, 6);
                info.rejected = this.optionalTimestamp(rs, 7);
                info.failed = this.optionalTimestamp(rs, 8);
                info.interaction = this.optionalTimestamp(rs, 9);
                info.type = rs.getString(10);
                list.add(info);
            }
        }
        return list;
    }

    private Principal loadPrincipalByCertId(PreparedStatement ps, String certId) throws SQLException {
        ps.setString(1, certId);
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                Principal principal = new Principal(rs.getInt(1), rs.getString(2));
                return principal;
            }
        }
        return null;
    }

    @Override
    public Principal accessPrincipal(String clientKey, String clientDn) throws SQLException {
        Principal p;
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement select_node = dbc.prepareStatement("SELECT id, subject_dn FROM nodes WHERE client_key=?");
            p = this.loadPrincipalByCertId(select_node, clientKey);
            if (p == null) {
                PreparedStatement ps = dbc.prepareStatement("INSERT INTO nodes(client_key, subject_dn, last_contact)VALUES(?,?,NOW())");
                ps.setString(1, clientKey);
                ps.setString(2, clientDn);
                ps.executeUpdate();
                ps.close();
                select_node.clearParameters();
                p = this.loadPrincipalByCertId(select_node, clientKey);
            } else {
                Statement st = dbc.createStatement();
                st.executeUpdate("UPDATE nodes SET last_contact=NOW() WHERE id=" + p.getNodeId());
                st.close();
            }
            select_node.close();
            dbc.commit();
        }
        return p;
    }

    private void updateRequestTimestamp(Connection dbc, int requestId, String timestampColumn, Instant value) throws SQLException {
        PreparedStatement ps = dbc.prepareStatement("UPDATE requests SET " + timestampColumn + "=? WHERE id=?");
        if (value != null) {
            ps.setTimestamp(1, Timestamp.from(value));
        } else {
            ps.setTimestamp(1, null);
        }
        ps.setInt(2, requestId);
        ps.executeUpdate();
        ps.close();
    }

    public void setRequestPublished(int requestId, Instant timestamp) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            this.updateRequestTimestamp(dbc, requestId, "published", timestamp);
            dbc.commit();
        }
    }

    public void setRequestClosed(int requestId, Instant timestamp) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            this.updateRequestTimestamp(dbc, requestId, "closed", timestamp);
            dbc.commit();
        }
    }

    @Override
    public void updateNodeLastSeen(int[] nodeIds, long[] timestamps) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("UPDATE nodes SET last_contact=? WHERE id=?");
            for (int i = 0; i < nodeIds.length; ++i) {
                ps.setInt(1, nodeIds[i]);
                ps.setTimestamp(2, new Timestamp(timestamps[i]));
                ps.executeUpdate();
            }
            ps.close();
        }
    }

    public void setRequestTargets(int requestId, int[] nodes) throws SQLException {
        Objects.requireNonNull(nodes);
        try (Connection dbc = this.brokerDB.getConnection();){
            Statement st = dbc.createStatement();
            st.executeUpdate("UPDATE requests SET targeted=TRUE WHERE id=" + requestId);
            st.close();
            st = dbc.createStatement();
            st.executeUpdate("DELETE FROM request_node_status WHERE request_id=" + requestId);
            st.close();
            PreparedStatement ps = dbc.prepareStatement("INSERT INTO request_node_status(request_id,node_id)VALUES(?,?)");
            ps.setInt(1, requestId);
            for (int i = 0; i < nodes.length; ++i) {
                ps.setInt(2, nodes[i]);
                ps.executeUpdate();
            }
            ps.close();
            dbc.commit();
        }
    }

    public int[] getRequestTargets(int requestId) throws SQLException {
        int[] nodes = null;
        try (Connection dbc = this.brokerDB.getConnection();){
            boolean isTargeted = false;
            Statement st = dbc.createStatement();
            ResultSet rs = st.executeQuery("SELECT targeted FROM requests WHERE id=" + requestId);
            if (rs.next()) {
                isTargeted = rs.getBoolean(1);
            }
            st.close();
            if (isTargeted) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                st = dbc.createStatement();
                rs = st.executeQuery("SELECT node_id FROM request_node_status WHERE request_id=" + requestId);
                while (rs.next()) {
                    list.add(rs.getInt(1));
                }
                rs.close();
                st.close();
                nodes = new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    nodes[i] = (Integer)list.get(i);
                }
            }
        }
        return nodes;
    }

    public void clearRequestTargets(int requestId) throws SQLException {
        try (Connection dbc = this.brokerDB.getConnection();){
            Statement st = dbc.createStatement();
            st.executeUpdate("UPDATE requests SET targeted=FALSE WHERE id=" + requestId);
            st.close();
        }
    }

    private String nodeResourceName(int nodeId, String resourceId, MediaType mediaType) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(nodeId).append('_').append(URLEncoder.encode(resourceId, "UTF-8"));
            if (mediaType.isCompatible(MediaType.TEXT_PLAIN_TYPE)) {
                builder.append(".txt");
            } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || mediaType.getSubtype().endsWith("+xml")) {
                builder.append(".xml");
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[][] replaceResourceFile(InputStream data, String oldFile, String newFile) throws IOException {
        DigestCalculatingInputStream di;
        if (oldFile != null) {
            try {
                Files.delete(this.dataDir.resolve(oldFile));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Unable to delete node resource: " + oldFile, e);
            }
        }
        try {
            di = new DigestCalculatingInputStream(data, RESOURCE_DIGESTS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("message digest SHA-256 not available");
        }
        Files.copy(di, this.dataDir.resolve(newFile), new CopyOption[0]);
        return di.getDigests();
    }

    @Override
    public void updateNodeResource(int nodeId, String resourceId, MediaType mediaType, InputStream content) throws IOException, SQLException {
        String oldFile = null;
        String newFile = this.nodeResourceName(nodeId, resourceId, mediaType);
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("SELECT data_file FROM node_resources WHERE node_id=? AND name=?");
            ps.setInt(1, nodeId);
            ps.setString(2, resourceId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                oldFile = rs.getString(1);
            }
            ps.close();
            ps = null;
            byte[][] digests = this.replaceResourceFile(content, oldFile, newFile);
            ps = oldFile != null ? dbc.prepareStatement("UPDATE node_resources SET media_type=?, last_modified=?, data_file=?, data_md5=?, data_sha2=? WHERE node_id=? AND name=?") : dbc.prepareStatement("INSERT INTO node_resources(media_type, last_modified, data_file, data_md5, data_sha2, node_id, name)VALUES(?,?,?,?,?,?,?)");
            ps.setString(1, mediaType.toString());
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, newFile);
            ps.setBytes(4, digests[0]);
            ps.setBytes(5, digests[1]);
            ps.setInt(6, nodeId);
            ps.setString(7, resourceId);
            ps.executeUpdate();
            ps.close();
            dbc.commit();
        }
    }

    public DigestPathDataSource getNodeResource(int nodeId, String resourceId) throws SQLException {
        byte[] sha2;
        byte[] md5;
        Path file;
        Instant lastModified;
        String mediaType;
        try (Connection dbc = this.brokerDB.getConnection();){
            PreparedStatement ps = dbc.prepareStatement("SELECT media_type, last_modified, data_file, data_md5, data_sha2 FROM node_resources WHERE node_id=? AND name=?");
            ps.setInt(1, nodeId);
            ps.setString(2, resourceId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                DigestPathDataSource digestPathDataSource = null;
                return digestPathDataSource;
            }
            mediaType = rs.getString(1);
            lastModified = rs.getTimestamp(2).toInstant();
            file = this.dataDir.resolve(rs.getString(3));
            md5 = rs.getBytes(4);
            sha2 = rs.getBytes(5);
            rs.close();
            ps.close();
        }
        DigestPathDataSource ds = new DigestPathDataSource(file, mediaType, lastModified);
        ds.md5 = md5;
        ds.sha256 = sha2;
        return ds;
    }

    public static int updatePrincipalDN(DataSource ds, Map<String, String> mapNodeDN) throws SQLException {
        int updated = 0;
        try (Connection dbc = ds.getConnection();){
            PreparedStatement update_dn = dbc.prepareStatement("UPDATE nodes SET subject_dn=? WHERE client_key=?");
            for (Map.Entry<String, String> entry : mapNodeDN.entrySet()) {
                update_dn.setString(1, entry.getValue());
                update_dn.setString(2, entry.getKey());
                updated += update_dn.executeUpdate();
            }
            update_dn.close();
        }
        return updated;
    }

    @FunctionalInterface
    public static interface RequestInfoLoader {
        public RequestInfo load(ResultSet var1) throws SQLException;
    }
}

